% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printTopWords.R
\name{printTopWords}
\alias{printTopWords}
\title{Print Top Words that Load Heavily on each Topic}
\usage{
printTopWords(object, n = 10, lowerPercentile = 0.05, upperPercentile = 0.95)
}
\arguments{
\item{object}{Model output from sts}

\item{n}{number of words to print to console for each topic}

\item{lowerPercentile}{Percentile to calculate a representative negative sentiment document.}

\item{upperPercentile}{Percentile to calculate a representative positive sentiment document.}
}
\description{
Prints the top words for each document for low, average, and high levels of sentiment-discourse
}
\examples{
\donttest{
#Examples with the Gadarian Data
library("tm"); library("stm"); library("sts")
temp<-textProcessor(documents=gadarian$open.ended.response,
metadata=gadarian, verbose = FALSE)
out <- prepDocuments(temp$documents, temp$vocab, temp$meta, verbose = FALSE)
out$meta$noTreatment <- ifelse(out$meta$treatment == 1, -1, 1)
## low max iteration number just for testing
sts_estimate <- sts(~ treatment*pid_rep, ~ noTreatment, out, K = 3, maxIter = 2)
printTopWords(sts_estimate)
}
}
