% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL_tbl_load.R
\name{download_studentlife}
\alias{download_studentlife}
\title{download_studentlife}
\usage{
download_studentlife(
  url = "dartmouth",
  location = ".",
  unzip = TRUE,
  untar = TRUE
)
}
\arguments{
\item{url}{A character string. Either
"rdata" for the URL to the (more efficient)
RData format version hosted on Zenodo, or
"dartmouth" for the (original) Dartmouth URL, or
"testdata" for a small sample dataset. Otherwise
a full URL of your choice can be specified leading to
the StudentLife dataset as a \code{.tar.gz} file.}

\item{location}{The destination path. If the path does
not exist it is created with \code{\link{dir.create}}}

\item{unzip}{Logical. If \code{TRUE} then the
dataset will be unzipped with \code{\link[R.utils]{bunzip2}}.
Leave as default unless you plan to do it manually.}

\item{untar}{Logical. If \code{TRUE} then the
dataset will be untarred with \code{\link[utils]{untar}}.
Leave as default unless you plan to do it manually.}
}
\description{
Download the entire StudentLife dataset or
a smaller sample dataset for testing.
}
\details{
If \code{url = "rdata"} then data will be downloaded
from <https://zenodo.org/record/3529253>
If \code{url = "dartmouth"} then data will be downloaded
from <https://studentlife.cs.dartmouth.edu/dataset/dataset.tar.bz2>
If \code{url = "testdata"} then data will be downloaded
from the test data at the studentlife GitHub repository
<https://github.com/frycast/studentlife>
}
\examples{
d <- tempdir()
download_studentlife(location = d, url = "testdata")

\dontrun{
## With menu
load_SL_tibble(location = d)
}

## Without menu
SL_tables
load_SL_tibble(schema = "EMA", table = "PAM", location = d)

}
