% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.caret.mSSL.R
\name{merged}
\alias{merged}
\title{Merged Approach for Multi-Study Learning: fits a single model on all studies merged into a single dataframe.}
\usage{
merged(formula = Y ~ ., data, sim.covs = NA, ssl.method = list("lm"),
  ssl.tuneGrid = list(c()), model = FALSE)
}
\arguments{
\item{formula}{Model formula}

\item{data}{A dataframe with all the studies has the following columns in this order: "Study", "Y", "V1", ...., "Vp"}

\item{sim.covs}{Is a vector of names of covariates or the column numbers of the covariates to be used for the similarity measure. Default is to use all covariates.}

\item{ssl.method}{A list of strings indicating which modeling methods to use}

\item{ssl.tuneGrid}{A list of the tuning parameters in the format of the caret package. Each element must be a dataframe (as required by caret). If no tuning parameters are required then NA is indicated}

\item{model}{Indicates whether to attach training data to model object}
}
\value{
A model object of studyStrap class "ss" that can be used to make predictions.
}
\description{
Merged Approach for Multi-Study Learning: fits a single model on all studies merged into a single dataframe.
}
\examples{
##########################
##### Simulate Data ######
##########################

set.seed(1)
# create half of training dataset from 1 distribution
X1 <- matrix(rnorm(2000), ncol = 2) # design matrix - 2 covariates
B1 <- c(5, 10, 15) # true beta coefficients
y1 <- cbind(1, X1) \%*\% B1

# create 2nd half of training dataset from another distribution
X2 <- matrix(rnorm(2000, 1,2), ncol = 2) # design matrix - 2 covariates
B2 <- c(10, 5, 0) # true beta coefficients
y2 <- cbind(1, X2) \%*\% B2

X <- rbind(X1, X2)
y <- c(y1, y2)

study <- sample.int(10, 2000, replace = TRUE) # 10 studies
data <- data.frame( Study = study, Y = y, V1 = X[,1], V2 = X[,2] )

# create target study design matrix for covariate profile similarity weighting and
# accept/reject algorithm (covaraite-matched study strap)
target <- matrix(rnorm(1000, 3, 5), ncol = 2) # design matrix
colnames(target) <- c("V1", "V2")

##########################
##### Model Fitting #####
##########################

# Fit model with 1 Single-Study Learner (SSL): PCA Regression
mrgMod1 <- merged(formula = Y ~.,
                  data = data,
                 sim.covs = NA,
                 ssl.method = list("pcr"),
                 ssl.tuneGrid = list( data.frame("ncomp" = 2)),
                 model = FALSE )

# 2 SSLs: Linear Regression and PCA Regression
mrgMod2 <- merged(formula = Y ~.,
                  data = data,
                 sim.covs = NA,
                 ssl.method = list("lm", "pcr"),
                 ssl.tuneGrid = list(NA,
                           data.frame("ncomp" = 2) ),
                 model = FALSE )

#########################
#####  Predictions ######
#########################

preds <- studyStrap.predict(mrgMod2, target)
}
