% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hovmoller.R
\name{hovmoller}
\alias{hovmoller}
\alias{hovmoller.data.frame}
\alias{hovmoller.stars}
\alias{autoplot.hovmoller}
\title{Computes the data structure for the Hovmoller plots}
\usage{
hovmoller(x, lat_or_lon = "lat", xlen = NULL, ...)

\method{hovmoller}{data.frame}(
  x,
  lat_or_lon = "lat",
  xlen = NULL,
  lat_or_lon_col,
  t_col,
  z_col,
  ...
)

\method{hovmoller}{stars}(x, lat_or_lon = "lat", xlen = NULL, ...)

\method{autoplot}{hovmoller}(
  object,
  ylab = "Day",
  xlab = NULL,
  title = "",
  palette = "Spectral",
  legend_title = "z",
  ...
)
}
\arguments{
\item{x}{A stars object or a dataframe. Arguments differ according to the input type.}

\item{lat_or_lon}{Needs to be either \code{lat} or \code{lon}. \code{lat} plots the latitudinal
Hovmoller plat, while \code{lon} plots the longitudinal Hovmoller plot.}

\item{xlen}{The length of the xaxis for latitude/longitude.}

\item{...}{Other arguments currently ignored.}

\item{lat_or_lon_col}{For dataframes: the column or the column name corresponding to the latitude/longitude.}

\item{t_col}{For dataframes: the time column. Time must be a set of discrete integer values.}

\item{z_col}{For dataframes: the The quantity of interest that will be plotted. Eg. temperature.}

\item{object}{For autoplot: the output of the function `hovmoller'.}

\item{ylab}{The y label.}

\item{xlab}{The x label.}

\item{title}{The graph title.}

\item{palette}{The color palette. Default is \code{Spectral}.}

\item{legend_title}{The title for the legend.}
}
\value{
An object of hovmoller class containing the original data and the Hovmoller data.
}
\description{
This function creates the data structure for Hovmoller plots for either latitude or longitude.
This function can take either a stars object or a dataframe. Input arguments differ for each case.
The function autoplot can plot this object.
}
\examples{
# dataframe examples
library(dplyr)
data(NOAA_df_1990)
Tmax <- filter(NOAA_df_1990,
  proc == "Tmax" &
  month \%in\% 5:9 &
  year == 1993 &
  id < 4000)
Tmax$t <- Tmax$julian - min(Tmax$julian) + 1
hov <- hovmoller(lat_or_lon = "lat",
          x = Tmax,
          lat_or_lon_col = 'lat',
          t_col = 't',
          z_col = 'z')
autoplot(hov)

# stars examples
library(stars)
prec_file = system.file("nc/test_stageiv_xyt.nc", package = "stars")
prec <- read_ncdf(prec_file)
prec2 <- prec \%>\% slice(time, 1:5)
hov <- hovmoller(prec2)
hov
}
