% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_sumup.R
\name{run_sumup}
\alias{run_sumup}
\title{Run Sum Up}
\usage{
run_sumup(dataset, settings = NULL)
}
\arguments{
\item{dataset}{A data frame containing the text data to be analyzed. It should include at least the following columns: \code{sentenceid}, \code{sentence}, \code{portfolioid}, \code{competencyid}, \code{feedbacktype}, and \code{datereferenced}.}

\item{settings}{A list containing settings for various processing steps. If not provided, default settings are used.}
}
\value{
A list or JSON output (depending on settings) containing the processed text data classified by topics and sentiment, as well as various metrics related to topics, such as strength and feedback count.
}
\description{
This function runs a series of text processing and analysis steps including text cleaning, tokenization, lemmatization, topic modeling, and sentiment analysis. It then classifies sentences into topics and generates an output summarizing the results.
}
\details{
This function performs the following steps:
\itemize{
\item Cleans the input text data using \code{text_clean}.
\item Tokenizes the text into sentences and removes stopwords.
\item Lemmatizes and annotates the sentences using a UDPipe model.
\item Counts word frequencies and excludes stopwords.
\item Performs topic modeling on the word counts.
\item Runs sentiment analysis based on the specified method (Grasp or SentimentR).
\item Classifies sentences into topics using the topic classification model.
\item Generates output summarizing the topics and sentiment.
}
}
\examples{
data(example_data)
ex_data <- example_data
ex_settings  <- set_default_settings()
ex_settings  <- update_setting(ex_settings , "language", "en")
ex_settings  <- update_setting(ex_settings , "use_sentiment_analysis", "sentimentr")
result <- run_sumup(ex_data, ex_settings )

}
