#' Simulated Quadratic Data
#'
#' Data simulated from a probit model with a quadratic trend. The data are
#' described in Example 2 of Liu and Zhang (2017).
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @format A data frame with 2000 rows and 2 variables.
#' \itemize{
#'   \item \code{y} The response variable; an ordered factor.
#'   \item \code{x} The predictor variable.
#' }
#'
#' @references
#' Liu, Dungang and Zhang, Heping. Residuals and Diagnostics for Ordinal
#' Regression Models: A Surrogate Approach.
#' \emph{Journal of the American Statistical Association} (accepted).
#'
#' @name df1
#'
#' @usage
#' data(df1)
#'
#' @examples
#' head(df1)
NULL


#' Simulated Heteroscedastic Data
#'
#' Data simulated from a probit model with heteroscedasticity. The data are
#' described in Example 4 of Liu and Zhang (2017).
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @format A data frame with 2000 rows and 2 variables.
#' \itemize{
#'   \item \code{y} The response variable; an ordered factor.
#'   \item \code{x} The predictor variable.
#' }
#'
#' @references
#' Liu, Dungang and Zhang, Heping. Residuals and Diagnostics for Ordinal
#' Regression Models: A Surrogate Approach.
#' \emph{Journal of the American Statistical Association} (accepted).
#'
#' @name df2
#'
#' @usage
#' data(df2)
#'
#' @examples
#' head(df2)
NULL


#' Simulated Gumbel Data
#'
#' Data simulated from a log-log model with a quadratic trend. The data are
#' described in Example 3 of Liu and Zhang (2017).
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @format A data frame with 2000 rows and 2 variables.
#' \itemize{
#'   \item \code{y} The response variable; an ordered factor.
#'   \item \code{x} The predictor variable.
#' }
#'
#' @references
#' Liu, Dungang and Zhang, Heping. Residuals and Diagnostics for Ordinal
#' Regression Models: A Surrogate Approach.
#' \emph{Journal of the American Statistical Association} (accepted).
#'
#' @name df3
#'
#' @usage
#' data(df3)
#'
#' @examples
#' head(df3)
NULL


#' Simulated Proportionality Data
#'
#' Data simulated from two separate ordered probit models with different
#' coefficients. The data are described in Example 5 of Liu and Zhang (2017).
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @format A data frame with 2000 rows and 2 variables.
#' \itemize{
#'   \item \code{y} The response variable; an ordered factor.
#'   \item \code{x} The predictor variable.
#' }
#'
#' @references
#' Liu, Dungang and Zhang, Heping. Residuals and Diagnostics for Ordinal
#' Regression Models: A Surrogate Approach.
#' \emph{Journal of the American Statistical Association} (accepted).
#'
#' @name df4
#'
#' @usage
#' data(df4)
#'
#' @examples
#' head(df4)
NULL


#' Simulated Interaction Data
#'
#' Data simulated from an ordered probit model with an interaction term.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @format A data frame with 2000 rows and 3 variables.
#' \itemize{
#'   \item \code{y} The response variable; an ordered factor.
#'   \item \code{x1} A continuous predictor.
#'   \item \code{x2} A factor with two levels: \code{Control} and
#'   \code{Treatment}.
#' }
#'
#' @name df5
#'
#' @usage
#' data(df5)
#'
#' @examples
#' head(df5)
NULL
