% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apc.R
\name{apc}
\alias{apc}
\alias{apc.surveil}
\alias{apc.stand_surveil}
\title{Annual and cumulative percent change}
\usage{
apc(x)

\method{apc}{surveil}(x)

\method{apc}{stand_surveil}(x)
}
\arguments{
\item{x}{A fitted \code{surviel} model, or standardized rates (a \code{stand_surveil} object).}
}
\value{
An \code{apc} (list) object containing the following data frames:
\describe{
\item{apc}{A data frame containing a summary of the posterior distribution for period-specific percent change. This contains the posterior mean (\code{apc}) 95 percent credible intervals (\code{lwr} and \code{upr} bounds).}
\item{cpc}{A data frame containing a summary of the posterior distribution for the cumulative percent change in risk at each time period. This contains the posterior mean (\code{cpc}) and 95 percent credible interval (\code{lwr} and \code{upr} bounds).}
\item{apc_samples}{MCMC samples from the posterior distribution for period percent change}
\item{cpc_samples}{MCMC samples from the posterior distribution for cumulative percent change}
}
}
\description{
Summarize annual and cumulative percent change in risk
}
\examples{
data(cancer)
cancer2 <- subset(cancer, grepl("55|60|65|70", Age))
fit <- stan_rw(cancer2, time = Year, group = Age,
                iter = 900) # low iter for speed only
 x <- apc(fit)
 print(x)
 plot(x, cumulative = TRUE)
}
\seealso{
\code{\link[surveil]{plot.apc}} \code{\link[surveil]{print.apc}} \code{\link[surveil]{stan_rw}} \code{\link[surveil]{standardize}}
}
