% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_weights.r
\name{rescaled.bootstrap.weights}
\alias{rescaled.bootstrap.weights}
\title{rescaled.bootstrap.weights}
\usage{
rescaled.bootstrap.weights(
  survey.data,
  survey.design,
  num.reps,
  weights = NULL,
  idvar,
  verbose = TRUE,
  parallel = FALSE,
  paropts = NULL
)
}
\arguments{
\item{survey.data}{The dataset to use}

\item{survey.design}{A formula describing the design of the survey
(see Details in \code{\link[=bootstrap.estimates]{bootstrap.estimates()}} help page)}

\item{num.reps}{the number of bootstrap replication samples to draw}

\item{weights}{weights to use in estimation (or NULL, if none)}

\item{idvar}{the name of the column in \code{survey.data} that has the respondent id}

\item{verbose}{if TRUE, produce lots of feedback about what is going on}

\item{parallel}{if TRUE, use the plyr library's .parallel argument to
produce bootstrap resamples and estimates in parallel}

\item{paropts}{if not NULL, additional arguments to pass along to the
parallelization routine}
}
\value{
if no summary.fn is specified, then return the list of estimates
produced by estimator.fn; if summary.fn is specified, then return
its output
}
\description{
This function creates a dataset with rescaled bootstrap weights;
it can be a helpful alternative to \code{bootstrap.estimates} in some situations
}
\details{
The formula describing the survey design should have the form
\code{~ psu_v1 + psu_v2 + ... + strata(strata_v1 + strata_v2 + ...)},
where \verb{psu_v1, ...} are the variables identifying primary sampling units (PSUs)
and \verb{strata_v1, ...} identify the strata
}
\examples{

survey <- MU284.complex.surveys[[1]]
rescaled.bootstrap.weights(survey.data = survey,
                          survey.design = ~ CL,
                          weights='sample_weight',
                          idvar='LABEL',
                          num.reps = 2)


\dontrun{
bootweights <- rescaled.bootstrap.weights(
                                         # formula describing survey design:
                                         # psu and strata
                                         survey.design = ~ psu +
                                                           stratum(stratum_analysis),
                                         num.reps=10000,
                                         # column with respondent ids
                                         idvar='caseid',
                                         # column with sampling weight
                                         weights='wwgt',
                                         # survey dataset
                                         survey.data=mw.ego)

}
}
