% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_uni_cat.R
\name{surv_uni_cat}
\alias{surv_uni_cat}
\title{Modify the Survival Output for a Categorical Variable.}
\usage{
surv_uni_cat(
  dat,
  stime,
  sevent,
  svar,
  month = 0,
  medianCI = TRUE,
  y1 = TRUE,
  y2 = TRUE,
  y5 = TRUE,
  report_index = FALSE
)
}
\arguments{
\item{dat}{a data.frame.}

\item{stime}{the duration of follow-up time in months.}

\item{sevent}{the status indicator, which is generally 0 = alive, 1 = dead.}

\item{svar}{a variable name.}

\item{month}{a number to get the month-rate of survival.}

\item{medianCI}{logical value indicating whether the 95 percent confidence interval of projected median survival should be reported.}

\item{y1}{logical value indicating whether the 1-year survival rate should be reported.}

\item{y2}{logical value indicating whether the 2-year survival rate should be reported.}

\item{y5}{logical value indicating whether the 5-year survival rate should be reported.}

\item{report_index}{logical value indicating if to report the show AIC and C index.}
}
\value{
a tibble of survival output
}
\description{
This function generates a table with the general survival analysis results, including the number of total patients, the number of sevents, the estimated median, the 1,2,5 year rate, the HR (95 percent confidence interval), the P value, the AIC, and the C index. This function just modifies the output table's format.
}
\examples{
Dat <- survival::lung
surv_uni_cat(Dat, "time", "status", "sex", report_index = TRUE)
}
