% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_lyx.R, R/tangle_lyx.R, R/weave_lyx.R
\name{clean_lyx}
\alias{clean_lyx}
\alias{cleanLyxRnw}
\alias{tangle_lyx}
\alias{tangleLyxRnw}
\alias{purl_lyx}
\alias{purlLyxRnw}
\alias{weave_lyx}
\alias{weaveLyxRnw}
\alias{knit_lyx}
\alias{knitLyxRnw}
\title{Clean up, weave or tangle Sweave files produced by LyX with the SciViews Sweave module}
\usage{
clean_lyx(RnwCon, RnwCon2 = RnwCon, encoding = "UTF-8")

cleanLyxRnw(RnwCon, RnwCon2 = RnwCon, encoding = "UTF-8")

tangle_lyx(
  file,
  driver = Rtangle(),
  syntax = getOption("SweaveSyntax"),
  encoding = "UTF-8",
  width = 80,
  useFancyQuotes = TRUE,
  annotate = TRUE,
  logFile = file.path(tempdir(), ".lyxSweave.log"),
  ...
)

tangleLyxRnw(
  file,
  driver = Rtangle(),
  syntax = getOption("SweaveSyntax"),
  encoding = "UTF-8",
  width = 80,
  useFancyQuotes = TRUE,
  annotate = TRUE,
  logFile = file.path(tempdir(), ".lyxSweave.log"),
  ...
)

purl_lyx(
  file,
  encoding = "UTF-8",
  width = 80,
  useFancyQuotes = TRUE,
  logFile = file.path(tempdir(), ".lyxSweave.log"),
  ...
)

purlLyxRnw(
  file,
  encoding = "UTF-8",
  width = 80,
  useFancyQuotes = TRUE,
  logFile = file.path(tempdir(), ".lyxSweave.log"),
  ...
)

weave_lyx(
  file,
  driver = RweaveLatex(),
  syntax = getOption("SweaveSyntax"),
  encoding = "UTF-8",
  width = 80,
  useFancyQuotes = TRUE,
  logFile = file.path(tempdir(), ".lyxSweave.log"),
  ...
)

weaveLyxRnw(
  file,
  driver = RweaveLatex(),
  syntax = getOption("SweaveSyntax"),
  encoding = "UTF-8",
  width = 80,
  useFancyQuotes = TRUE,
  logFile = file.path(tempdir(), ".lyxSweave.log"),
  ...
)

knit_lyx(
  file,
  encoding = "UTF-8",
  width = 80,
  useFancyQuotes = TRUE,
  logFile = file.path(tempdir(), ".lyxSweave.log"),
  ...
)

knitLyxRnw(
  file,
  encoding = "UTF-8",
  width = 80,
  useFancyQuotes = TRUE,
  logFile = file.path(tempdir(), ".lyxSweave.log"),
  ...
)
}
\arguments{
\item{RnwCon}{A connection object or a character string corresponding to the
path to a R noweb file to be read.}

\item{RnwCon2}{Idem, but where the cleaned up R noweb file should be written
(by default, on the same file or connection).}

\item{encoding}{The encoding of the \code{.Rnw} file. It is UTF-8 by default, but
you can change it here.}

\item{file}{The Sweave source file.}

\item{driver}{The actual function to do the process, see \code{\link[=Sweave]{Sweave()}}.}

\item{syntax}{\code{NULL} or an object of class 'SweaveSyntax' or a character
string with its name,  see \code{\link[=Sweave]{Sweave()}}.}

\item{width}{The width used for outputs, 80 characters by default.}

\item{useFancyQuotes}{Do we use fancy quotes in R outputs?}

\item{annotate}{Is the R code extracted from the \code{.Rnw} file annotated?}

\item{logFile}{The file to use to log results of weaving/tangling the
document.}

\item{...}{Further arguments passed to the driver's setup function of
\code{\link[=Sweave]{Sweave()}} or \code{\link[=Stangle]{Stangle()}}.}
}
\value{
For \code{\link[=clean_lyx]{clean_lyx()}}, a list for Sweave options found in the document; \code{NULL}
for the other functions: these functions are invoked for their side effects.
The function \code{\link[=weave_lyx]{weave_lyx()}} uses the standard Sweave driver (but it uses knitr
for LyX documents that use the SciViews Knitr module), while \code{\link[=knit_lyx]{knit_lyx()}}
does the same, but using the knitr driver. Similarly, \code{\link[=purl_lyx]{purl_lyx()}} is the
knitr counterpart of \code{\link[=tangle_lyx]{tangle_lyx()}} standard tangling function.
}
\description{
These functions process \verb{.Rnw`` files produced by LyX and the SciViews Sweave module (not the standard Sweave module provided with LyX <= 2.0.0!). The SciViews-LyX extension defines }rchunk` commands to contain R chunks
(embedded R code processed by Sweave). Unfortunately, LyX use to write two
lines feeds for each line of code, introducing extra lines in the R chunks.
Moreover, tabulations are interpreted as 8 spaces, while R code use to
consider a tabulation as equivalent to 4 spaces. \code{\link[=clean_lyx]{clean_lyx()}} corrects
these little problems, and it should not affect R noweb files produced by a
different software.
}
\seealso{
\code{\link[knitr:knit]{knitr::knit()}}, \code{\link[utils:Sweave]{utils::Sweave()}}
}
\author{
Philippe Grosjean
}
\concept{Literate programming}
\keyword{utilities}
