% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.svrpath.R
\name{predict.svrpath}
\alias{predict.svrpath}
\title{Make predictions from a "svrpath" object}
\usage{
\method{predict}{svrpath}(object, newx, lambda = NULL, criterion = "sic",
  ...)
}
\arguments{
\item{object}{The svrpath object}

\item{newx}{Values of x to be predicted. This is a matrix with observations per row. Default is x in the epspath object.}

\item{lambda}{The value of the regularization paramter, lambda.}

\item{criterion}{It provides predictions at an optimal \code{lambda} selected by SIC or GACV. \code{"sic"} or \code{"gacv"}.}

\item{...}{Generic compatibility}
}
\value{
In each case, the desired prediction.
}
\description{
Provides a prediction value at a given \code{lambda} from \code{svrpath} object.
}
\examples{
\donttest{
# The 'eobj' is given by examples description of epspath().
predict.svrpath(obj, lambda = 10) # or
predict(obj, criterion = 'sic') }

}
\author{
Do Hyun Kim, Seung Jun Shin
}
