% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\name{dist_cosine}
\alias{dist_cosine}
\alias{dist_cos}
\title{Compute Cosine Distances}
\usage{
dist_cosine(x, diag = FALSE, upper = FALSE)

dist_cos(x, diag = FALSE, upper = FALSE)
}
\arguments{
\item{x}{A numeric matrix (containing coordinates).}

\item{diag}{Logical specifying whether the diagonal of the resulting distance matrix should be printed.}

\item{upper}{Logical specifying whether the upper triangle of the resulting distance matrix should be printed.}
}
\value{
A distance matrix.
}
\description{
A function for computing cosine distances.
}
\details{
The cosine distance equals 1 - the cosine similarity.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\t", quote = "\"", encoding = "UTF-8",
   stringsAsFactors = FALSE)
lsa_SndT_Fra <- fast_lsa(SndT_Fra)
dist_cosine(lsa_SndT_Fra$pos1[, 1:7])
}
