% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w8margin_functions.R
\name{w8margin_matched}
\alias{w8margin_matched}
\title{Check if w8margin Matches Observed Data}
\usage{
w8margin_matched(w8margin, observed, refactor = FALSE, 
  na.targets.allow = FALSE, zero.targets.allow = FALSE)
}
\arguments{
\item{w8margin}{w8margin object, or other object type that can be coerced to
w8margin with a temporary variable name.}

\item{observed}{factor vector (or, if \code{refactor = TRUE}, a vector that can
be coerced to factor).}

\item{refactor}{logical, specifying whether to factor observed variable before checking
match.}

\item{na.targets.allow}{logical, indicating whether NA values in target should produce error (\code{FALSE}, the default)
or be allowed. NA values are never allowed in observed data.}

\item{zero.targets.allow}{logical, indicating whether zero values in target should produce error (\code{FALSE}, the default)
or be allowed.}
}
\value{
A logical, indicating whether w8margin is compatible with observed.
}
\description{
Checks whether specified \code{\link{w8margin}} object and variable in observed
data are compatible, and are expected to produce valid call to
\code{\link[survey]{rake}}. Returns a logical true/false, and generates
warning messages to specify likely issues. Intended to help quickly
diagnose incompatibilities between w8margins and observed data.
}
\details{
With default parameters (\code{na.targets.allow = FALSE}, \code{zero.targets.allow = FALSE},
and \code{refactor = FALSE}), the function checks whether a \code{w8margin}
object is in the strict format required by \code{\link[survey]{rake}}; this format
will also be accepted by \code{\link[=rakesvy]{rakesvy()}} and \code{\link[=rakew8]{rakew8()}}. Changing
the default parameters relaxes some checks. With the parameters
altered, the function will only assess whether \code{w8margin} objects are
usable by \code{\link[=rakesvy]{rakesvy()}} and \code{\link[=rakew8]{rakew8()}}, which
accept a more flexible range of target formats.

It should not generally be necessary to call \code{w8margin_matched()} manually when
using \code{\link[=rakesvy]{rakesvy()}} and \code{\link[=rakew8]{rakew8()}} to compute weights.
However,  may be useful to call directly, when manually calling underlying
weighting functions from the \code{survey} package, or for diagnostic purposes.
}
\examples{
gender_w8margin <- as.w8margin(
    c(Male = .49, Female = .51),
    varname = "gender", 
    samplesize = 2179)
# Returns TRUE
w8margin_matched(gender_w8margin, gles17$gender)

gender_w8margin_alt <- as.w8margin(
    c(man = .49, woman = .51), 
    varname = "gender", 
    samplesize = 2179)
# Returns FALSE - level names in gles17$gender do not match level names in gender_w8margin_alt
w8margin_matched(gender_w8margin_alt, gles17$gender)

agecat_50plus_w8margin <- as.w8margin(
    c("50-59" = .35, "60-69" = .27, ">=70" = .38),
    varname = "educ",
    samplesize = 2179
)
gles17_50plus <- gles17[gles17$agecat \%in\% c("50-59", "60-69", ">=70"),]
# Returns FALSE - gles17$agecat has empty factor levels for <=29, 30-39, 40-49
w8margin_matched(agecat_50plus_w8margin, gles17_50plus$agecat)
# Returns TRUE - gles17$agecat is refactored to drop empty levels
w8margin_matched(agecat_50plus_w8margin, gles17_50plus$agecat, refactor = TRUE)
}
