% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn.R
\name{nnd}
\alias{nnd}
\title{Nearest Neihgbor Distance}
\usage{
nnd(x, y, geo = FALSE)
}
\arguments{
\item{x}{A vector of x (or longitude) coordinates.}

\item{y}{A vector of y (or latitude) coordinates.}

\item{geo}{A logical value indicating whether the locations are defined by 
geographic coordinates (pairs of longitude/latitude values). Default: FALSE.}
}
\value{
A vector of the same length as x and y representing the distance to 
 the nearest neighboring object for each object.
}
\description{
Given the locations of different objects, this function 
 determines the distance of the nearest neighboring object to each object.
}
\examples{
x <- rnorm(25)
y <- rnorm(25, sd = 3)
id <- 1:25
nnd(x, y)

}
\seealso{
\code{\link{nn}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
