% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn.R
\name{pdist}
\alias{pdist}
\title{Pairwise Distance Matrix}
\usage{
pdist(x, y, geo = FALSE)
}
\arguments{
\item{x}{A vector of x (or longitude) coordinates.}

\item{y}{A vector of y (or latitude) coordinates.}

\item{geo}{A logical value indicating whether the locations are defined by 
geographic coordinates (pairs of longitude/latitude values). Default: FALSE.}
}
\value{
A square matrix representing pairwise distances between each possible 
 pair of locations.
}
\description{
Given a set of locations, this function computes the distances 
 between each possible pair of locations.
}
\examples{
x <- rnorm(25)
y <- rnorm(25, sd = 3)
pdist(x, y)

}
\seealso{
\code{\link{nn}}, \code{\link{nnd}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
