% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.swag}
\alias{predict.swag}
\title{Predict method for SWAG}
\usage{
\method{predict}{swag}(
  object,
  newdata = NULL,
  type = c("best", "cv_performance", "attribute"),
  cv_performance = NULL,
  attribute = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{\link{swag}}.}

\item{newdata}{an optional set of data to predict on. If \code{NULL}
the original training data are used.}

\item{type}{type of prediction required. The default is "best", it takes
the best model (with lowest CV errors). The option "cv_performance"
(which requires \code{cv_performance}) allows
to set a level of CV errors under which models are predicted. The option
"attribute" (which requires \code{attribute}) allows to specify an attribute
at which models are predicted.}

\item{cv_performance}{a level of CV errors (between 0 and 1) combines with
\code{type} "cv_performance".}

\item{attribute}{an attribute combines with \code{type} "attribute".}

\item{...}{Not used for the moment.}
}
\value{
Predictions .
}
\description{
Gives predictions for different \code{\link[caret]{train}}
learners obtained by \code{swag}.
}
\details{
Currently the different \code{\link[caret]{train}}
learners are trained (again) to make the predictions.
}
\author{
Gaetan Bakalli, Samuel Orso and Cesare Miglioli
}
