% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin.R
\name{pin_coordn}
\alias{pin_coordn}
\title{Check if \code{pin} is a coordination number}
\usage{
pin_coordn(pin)
}
\arguments{
\item{pin}{A vector of class \code{pin}. See \link{as.pin}.}
}
\value{
Logical vector indicating if the pin is a coordination number (\code{TRUE}) or pin (\code{FALSE}).
}
\description{
Calculate if the personal identity number is a coordination number.
}
\examples{
# Examples taken from SKV 704 (see references)
ex_pin <- c("196408233234", "196408833224")
pin_coordn(ex_pin)

}
\references{
\itemize{
 \item Skatteverket, \href{https://github.com/rOpenGov/sweidnumbr/blob/master/docs/skv717B-4.pdf}{\emph{Population registration in Sweden}}. SKV 717B. (2007)
 \item Skatteverket, \href{https://github.com/rOpenGov/sweidnumbr/blob/master/docs/skv704-8.pdf}{\emph{Personnummer}}. SKV 704. (2007)
 \href{https://www.riksdagen.se/sv/dokument-och-lagar/dokument/statens-offentliga-utredningar/personnummer-och-samordningsnummer-del-1_gwb360/}{SOU 2008:60 : Personnummer och samordningsnummer}, (2008)
}
}
