% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available.sylly.lang.R
\name{available.sylly.lang}
\alias{available.sylly.lang}
\title{List available language packages}
\usage{
available.sylly.lang(repos = "https://undocumeantit.github.io/repos/l10n/")
}
\arguments{
\item{repos}{The URL to additional repositories to query. You should probably leave this to the
default, but if you would like to use a third party repository, you're free to do so. The
value is temporarily appended to the repos currently returned by \code{getOption("repos")}.}
}
\value{
Returns an invisible character vector with all available language packages.
}
\description{
Get a list of all currently available language packages for sylly from the official
l10n repository.
}
\details{
sylly's language support is modular by design, meaning you can load
an extension package for each language you want to work with in a given session.
These language support packages are named \code{sylly.**}, where \code{**}
is replaced by a valid language identifier (like \code{en} for English or \code{de}
for German). See \code{\link[sylly:set.hyph.support]{set.hyph.support}} for more details.

This function downloads the package list from (also) the official localization repository
for sylly and lists all currently available language packages that you could install
and load. Apart from than it does not download or install anything.

You can install the packages by either calling the convenient wrapper function
\code{\link[sylly:install.sylly.lang]{install.sylly.lang}}, or
\code{\link[utils:install.packages]{install.packages}} (see examples).
}
\examples{
\dontrun{
# see all available language packages
available.sylly.lang()

# install support for German
install.sylly.lang("de")
# alternatively, you could call install.packages directly
install.packages("sylly.de", repos="https://undocumeantit.github.io/repos/l10n/")
}
}
\seealso{
\code{\link[sylly:install.sylly.lang]{install.sylly.lang}}
}
