% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{detrend}
\alias{detrend}
\alias{trInfo}
\title{Remove offsets and linear trends}
\usage{
detrend(x, type = 0)
}
\arguments{
\item{x}{an object of class \code{idframe}}

\item{type}{argument indicating the type of trend to be removed (Default=\code{0})
\itemize{
  \item type=\code{0}: Subtracts mean value from each signal
  \item type=\code{1}: Subtracts a linear trend (least-squres fit)
  \item type=\code{trInfo} object: Subtracts a trend specified by the object
}}
}
\value{
A list containing two objects: the detrended data and the trend information
}
\description{
Removes offsets or trends from data
}
\details{
\code{R} by default doesn't allow return of multiple objects. The \code{\%=\%}
operator and \code{g} function in this package facillitate this behaviour. See 
the examples section for more information.
}
\examples{
data(cstr)
datatrain <- dataSlice(cstr,end=4500)
datatest <- dataSlice(cstr,4501)
g(Ztrain,tr) \%=\% detrend(datatrain) # Remove means
g(Ztest) \%=\% detrend(datatest,tr)

}
\seealso{
\code{\link[stats]{lm}}
}

