% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HierarchicalModels.R
\name{sample_HierarchicalModel}
\alias{sample_HierarchicalModel}
\title{Sample from Hierarchical Model with given Row and Column Sums}
\usage{
sample_HierarchicalModel(
  l,
  a,
  L_fixed = NA,
  model,
  nsamples = 10000,
  thin = choosethin(l = l, a = a, L_fixed = L_fixed, model = model, matrpertheta =
    matrpertheta, silent = silent),
  burnin = NA,
  matrpertheta = length(l)^2,
  silent = FALSE,
  tol = .Machine$double.eps^0.25
)
}
\arguments{
\item{l}{observed row sum}

\item{a}{observerd column sum}

\item{L_fixed}{Matrix containing known values of L, where NA
signifies that an element is not known. If \code{L_fixed} equates
to \code{NA} (the default) then no values are assumed to be known.}

\item{model}{Underlying model for p and lambda.}

\item{nsamples}{number of samples to return.}

\item{thin}{how many updates of theta to perform before outputting a sample.}

\item{burnin}{number of iterations for the burnin. Defaults to 5%
of the steps in the sampling part.}

\item{matrpertheta}{number of matrix updates per update of theta.}

\item{silent}{(default FALSE) suppress all output (including progress bars).}

\item{tol}{tolerance used in checks for equality. Defaults to \code{.Machine$double.eps^0.25}.}
}
\value{
The resulting samples. A list with the first element, L, giving the samples of matrices, and the second element, theta, giving the samples of the hyperparameter (if hyperparameters are present).
}
\description{
Sample from Hierarchical Model with given Row and Column Sums
}
\examples{
n <- 10
m <- Model.Indep.p.lambda(Model.p.BetaPrior(n),
                          Model.lambda.GammaPrior(n,scale=1e-1))
x <- genL(m)
l <- rowSums(x$L)
a <- colSums(x$L)
\donttest{
res <- sample_HierarchicalModel(l,a,model=m)
}
# fixing one values
L_fixed <- matrix(NA,ncol=n,nrow=n)
L_fixed[1,2:5] <- x$L[1,2:5]
\donttest{
res <- sample_HierarchicalModel(l,a,model=m,L_fixed=L_fixed,
                                nsamples=1e2)
sapply(res$L,function(x)x[1,2:5])
}

}
