% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabfreq_svy.R
\name{tabfreq.svy}
\alias{tabfreq.svy}
\title{Create Frequency Table (for Complex Survey Data)}
\usage{
tabfreq.svy(
  formula,
  design,
  columns = c("xgroups", "p"),
  cell = "col.percent",
  parenth = "se",
  sep.char = ", ",
  xlevels = NULL,
  yname = NULL,
  ylevels = NULL,
  compress.binary = FALSE,
  yname.row = TRUE,
  text.label = NULL,
  decimals = 1,
  svychisq.list = NULL,
  formatp.list = NULL,
  n.headings = FALSE,
  N.headings = FALSE,
  kable = TRUE
)
}
\arguments{
\item{formula}{Formula, e.g. \code{Race ~ Sex}.}

\item{design}{Survey design object from \code{\link[survey]{svydesign}}.}

\item{columns}{Character vector specifying what columns to include. Choices
for each element are \code{"n"} for total unweighted sample size, \code{"N"}
for total weighted sample size, \code{"overall"} for overall distribution of
\code{y}, \code{"xgroups"} for distributions of \code{y} for each \code{x}
group, and \code{"p"} for Chi-square p-value.}

\item{cell}{Character string specifying what statistic to display in cells.
Choices are \code{"n"}, \code{"N"}, and \code{"col.percent"}.}

\item{parenth}{Character string specifying what statistic to display in
parentheses. Choices are \code{"none"}, \code{"n"}, \code{"N"},
\code{"col.percent"}, \code{"se"}, and \code{"ci"}.}

\item{sep.char}{Character string with separator to place between lower and
upper bound of confidence intervals. Typically \code{"-"} or \code{", "}.}

\item{xlevels}{Character vector with labels for the levels of \code{x}, used
in column headings.}

\item{yname}{Character string with a label for the \code{y} variable.}

\item{ylevels}{Character vector with labels for the levels of \code{y}. Note
that levels of \code{y} are listed in the order that they appear when you run
\code{table(y, x)}.}

\item{compress.binary}{Logical value for whether to compress binary \code{y}
variable to a single row, excluding the first level rather than showing both.}

\item{yname.row}{Logical value for whether to include a row displaying the
name of the \code{y} variable.}

\item{text.label}{Character string with text to put after the \code{y}
variable name, identifying what cell values and parentheses represent.}

\item{decimals}{Numeric value specifying number of decimal places for numbers
other than p-values.}

\item{svychisq.list}{List of arguments to pass to
\code{\link[survey]{svychisq}}.}

\item{formatp.list}{List of arguments to pass to \code{\link[tab]{formatp}}.}

\item{n.headings}{Logical value for whether to display unweighted sample
sizes in parentheses in column headings.}

\item{N.headings}{Logical value for whether to display weighted sample sizes
in parentheses in column headings.}

\item{kable}{Logical value for whether to return a
\code{\link[knitr]{kable}}.}
}
\value{
\code{\link[knitr]{kable}} or character matrix.
}
\description{
Creates an I-by-J frequency table comparing the distribution of \code{y}
across levels of \code{x}.
}
\details{
Basically \code{\link{tabmedians}} for complex survey data. Relies heavily on
the \pkg{survey} package.
}
\examples{
# Create survey design object
library("survey")
design <- svydesign(
  data = tabsvydata,
  ids = ~sdmvpsu,
  strata = ~sdmvstra,
  weights = ~wtmec2yr,
  nest = TRUE
)

# Compare race distribution by sex
tabfreq.svy(Race ~ Sex, design)


}
