% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabmulti_svy.R
\name{tabmulti.svy}
\alias{tabmulti.svy}
\title{Create Table Comparing Characteristics Across Levels of a Categorical
Variable (for Complex Survey Data)}
\usage{
tabmulti.svy(
  formula = NULL,
  design,
  xvarname = NULL,
  yvarnames = NULL,
  ymeasures = NULL,
  columns = c("xgroups", "p"),
  listwise.deletion = FALSE,
  sep.char = ", ",
  xlevels = NULL,
  yvarlabels = NULL,
  ylevels = NULL,
  decimals = NULL,
  formatp.list = NULL,
  n.headings = FALSE,
  N.headings = FALSE,
  kable = TRUE,
  tabmeans.svy.list = NULL,
  tabmedians.svy.list = NULL,
  tabfreq.svy.list = NULL
)
}
\arguments{
\item{formula}{Formula, e.g. \code{Age + Race + BMI ~ Sex}.}

\item{design}{Survey design object from \code{\link[survey]{svydesign}}.}

\item{xvarname}{Character string with name of column variable. Should be one
of \code{names(design$variables)}.}

\item{yvarnames}{Character vector with names of row variables. Each element
should be one of \code{names(design$variables)}.}

\item{ymeasures}{Character vector specifying whether each \code{y} variable
should be summarized by mean, median, or frequency. For example, if you want
to compare frequencies for the first variable, means for the second, and
medians for the third, you would set
\code{ymeasures = c("freq", "mean", "median")}. If unspecified, function
compares means for numeric variables and frequencies for factor and character
variables.}

\item{columns}{Character vector specifying what columns to include. Choices
for each element are \code{"n"} for unweighted sample size, \code{"N"} for
weighted sample size, \code{"overall"} for overall statistics,
\code{"xgroups"} for \code{x} group statistics, and \code{"p"} for p-value.}

\item{listwise.deletion}{Logical value for whether observations with missing
values for any \code{y} variable should be excluded entirely (as opposed to
using all available data for each comparison).}

\item{sep.char}{Character string with separator to place between lower and
upper bound of confidence intervals. Typically \code{"-"} or \code{", "}.}

\item{xlevels}{Character vector with labels for the levels of \code{x}, used
in column headings.}

\item{yvarlabels}{Named list specifying labels for certain \code{y}
variables. For example, if you want variables named "race" and "age_yrs" to
print as "Race/ethnicity" and "Age (years)", use
\\code{yvarlabels = list(race = "Race/ethnicity", age_yrs = "Age (years)")}.}

\item{ylevels}{Character vector (if only 1 frequency comparison) or list of
character vectors with labels for the levels of each categorical \code{y}
variable.}

\item{decimals}{Numeric vector specifying number of decimal places for
numbers other than p-values for each \code{y} variable. Can be a single value
to use for all \code{y} variables.}

\item{formatp.list}{List of arguments to pass to \code{\link[tab]{formatp}}.}

\item{n.headings}{Logical value for whether to display unweighted sample
sizes in parentheses in column headings.}

\item{N.headings}{Logical value for whether to display weighted sample sizes
in parentheses in column headings.}

\item{kable}{Logical value for whether to return a
\code{\link[knitr]{kable}}.}

\item{tabmeans.svy.list}{List of arguments to pass to
\code{\link{tabmeans.svy}}.}

\item{tabmedians.svy.list}{List of arguments to pass to
\code{\link{tabmedians.svy}}.}

\item{tabfreq.svy.list}{List of arguments to pass to
\code{\link{tabfreq.svy}}.}
}
\value{
\code{\link[knitr]{kable}} or character matrix.
}
\description{
Creates a table comparing multiple characteristics (e.g. median age, mean
BMI, and race/ethnicity distribution) across levels of \code{x}.
}
\details{
Basically \code{\link{tabmulti}} for complex survey data. Relies heavily on
the \pkg{survey} package.
}
\examples{
# Create survey design object
library("survey")
design <- svydesign(
  data = tabsvydata,
  ids = ~sdmvpsu,
  strata = ~sdmvstra,
  weights = ~wtmec2yr,
  nest = TRUE
)

# Compare age, race, and BMI by sex
tabmulti.svy(Age + Race + BMI ~ Sex, design)


}
