% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{tablerProfileCard}
\alias{tablerProfileCard}
\title{Create a Boostrap 4 profile card}
\usage{
tablerProfileCard(
  title = NULL,
  subtitle = NULL,
  background = NULL,
  src = NULL,
  socials = NULL,
  width = 4
)
}
\arguments{
\item{title}{Profile title.}

\item{subtitle}{Card subtitle.}

\item{background}{Card background url or path.}

\item{src}{User profile image.}

\item{socials}{Slot for \link{tablerSocialLinks} and \link{tablerSocialLink}.}

\item{width}{Card width. 4 by default.}
}
\description{
Build a tabler profile card
}
\examples{
if(interactive()){
 library(shiny)
 library(tablerDash)

 shiny::shinyApp(
   ui = tablerDashPage(
    navbar = NULL,
    footer = NULL,
    title = "test",
    body = tablerDashBody(
     tablerProfileCard(
      title = "Peter Richards",
      subtitle = "Big belly rude boy, million
      dollar hustler. Unemployed.",
      background = "https://preview.tabler.io/demo/photos/ilnur-kalimullin-218996-500.jpg",
      src = "https://preview.tabler.io/demo/faces/male/16.jpg",
      tablerSocialLinks(
       tablerSocialLink(
        name = "facebook",
        href = "https://www.facebook.com",
        icon = "facebook"
       ),
       tablerSocialLink(
        name = "twitter",
        href = "https://www.twitter.com",
        icon = "twitter"
       )
      )
     )
    )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
