% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{parser}
\alias{parser}
\alias{is.parser}
\title{Parser Objects}
\usage{
parser(x, f, name = NULL)

is.parser(x)
}
\arguments{
\item{x}{A regex string, a parser, or a list of either; Or object to be tested}

\item{f}{A function to format the captured output, or a named list of such
functions if \code{x} is a list}

\item{name}{An optional name for the parser}
}
\value{
\code{parser} and its S3 methods coerce \code{x} to a \code{parser} object,
        returning said parser object. \code{is.parser} returns TRUE or FALSE
}
\description{
Create or test for parser objects. These objects will be used by templates to
identify a field within a log file.
}
\details{
Parser objects contain 3 things:
\enumerate{
    \item A regex expression that matches the given field
    \item A 'formatter'; a function that will in some way modify the captured text
    \itemize{
        \item By default, this the identity function
    }
    \item (Optional) A name for the parser
}
}
\examples{
# Captures integers
parser('[0-9]+')

# Captures integers, cast to integers
parser('[0-9]+', as.integer)

# List of parsers, all named (inferred from list names), some with parsers
parser(
  list(
    ip = '[0-9]{1,3}(\\\\.[0-9]{1,3}){3}',
    int = '[0-9]+',
    date = '[0-9]{4}\\\\-[0-9]{2}\\\\-[0-9]{2}'
  ),
  list(int = as.integer, date = as.Date)
)

is.parser(parser('[0-9]+')) #TRUE
is.parser(100)              #FALSE

}
