% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Other.R
\name{stdfEmpCorr}
\alias{stdfEmpCorr}
\title{Bias-corrected empirical stable tail dependence function}
\usage{
stdfEmpCorr(
  ranks,
  k,
  cst = rep(1, ncol(ranks)),
  tau = 5,
  k1 = (nrow(ranks) - 10)
)
}
\arguments{
\item{ranks}{A \code{n} x \code{d} matrix, where each column is a permutation of the integers \code{1:n}, representing the ranks computed from a sample of size \code{n}.}

\item{k}{An integer between 1 and \eqn{n - 1}; the threshold parameter in the definition of the empirical stable tail dependence function.}

\item{cst}{The value in which the tail dependence function is evaluated: defaults to \code{rep(1,d)}.}

\item{tau}{The parameter of the power kernel. Defaults to 5.}

\item{k1}{An integer between 1 and \eqn{n}; defaults to \eqn{n} - 10.}
}
\value{
A scalar between \eqn{\max(x_1,\ldots,x_d)} and \eqn{x_1 + \cdots + x_d}.
}
\description{
Returns the bias-corrected stable tail dependence function in dimension \code{d}, evaluated in a point \code{cst}.
}
\details{
The values for \code{k1} and \code{tau} are chosen as recommended in Beirlant et al. (2016). This function might be slow for large \code{n}.
}
\examples{
## Simulate data from the Gumbel copula
set.seed(2)
cop <- copula::gumbelCopula(param = 2, dim = 4)
data <- copula::rCopula(n = 1000, copula = cop)
stdfEmpCorr(apply(data,2,rank), k = 50)
}
\references{
Einmahl, J.H.J., Kiriliouk, A., and Segers, J. (2018). A continuous updating weighted least squares estimator of tail dependence in high dimensions. Extremes 21(2), 205-233.

Beirlant, J., Escobar-Bach, M., Goegebeur, Y., and Guillou, A. (2016). Bias-corrected estimation of stable tail dependence function. Journal of Multivariate Analysis, 143, 453-466.
}
\seealso{
\code{\link{stdfEmp}}
}
