% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summary.ELT.R
\name{summary.ELT}
\alias{summary.ELT}
\title{Summary statistics for class ELT.}
\usage{
\method{summary}{ELT}(object, theta = 0, cap = Inf, t = 1, ...)
}
\arguments{
\item{object}{An object of class \code{ELT}. Data frame containing two numeric columns. The column \code{Loss} contains the expected losses from each single occurrence of event. The column \code{Rate} contains the arrival rates of a single occurrence of event.}

\item{theta}{Scalar containing information about the variance of the Gamma distribution: \eqn{sd[X] = x * }\code{theta}. The default value is \code{theta} = 0: the loss associated to an event is considered as a constant.}

\item{cap}{Scalar representing the financial cap on losses for a single event, i.e. the maximum possible loss caused by a single event. The default value is \code{cap} = Inf.}

\item{t}{Scalar representing the time period of interest. The default value is \code{t} = 1.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A list containing the data summary, and the means and the standard deviations of \eqn{N}, \eqn{Y}, and \eqn{S}.
}
\description{
Summary statistics for class ELT.
}
\examples{
data(UShurricane)
summary(ELT(UShurricane))
}

