% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_sitrep.R
\name{tar_sitrep}
\alias{tar_sitrep}
\title{Show the cue-by-cue status of each target.}
\usage{
tar_sitrep(
  names = NULL,
  fields = NULL,
  shortcut = targets::tar_config_get("shortcut"),
  reporter = targets::tar_config_get("reporter_outdated"),
  seconds_reporter = targets::tar_config_get("seconds_reporter_outdated"),
  callr_function = callr::r,
  callr_arguments = targets::tar_callr_args_default(callr_function, reporter),
  envir = parent.frame(),
  script = targets::tar_config_get("script"),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{names}{Optional, names of the targets. If supplied, \code{tar_sitrep()}
only returns metadata on these targets.
The object supplied to \code{names} should be \code{NULL} or a
\code{tidyselect} expression like \code{\link[=any_of]{any_of()}} or \code{\link[=starts_with]{starts_with()}}
from \code{tidyselect} itself, or \code{\link[=tar_described_as]{tar_described_as()}} to select target names
based on their descriptions.}

\item{fields}{Optional, names of columns/fields to select. If supplied,
\code{tar_sitrep()} only returns the selected metadata columns.
You can supply symbols or \code{tidyselect} helpers
like \code{\link[=any_of]{any_of()}} and \code{\link[=starts_with]{starts_with()}}.
The \code{name} column is always included first
no matter what you select. Choices:
\itemize{
\item \code{name}: name of the target or global object.
\item \code{meta}: Whether the \code{meta} cue is activated:
\code{TRUE} if the target is not in the metadata (\code{\link[=tar_meta]{tar_meta()}}),
or if the target errored during the last \code{\link[=tar_make]{tar_make()}},
or if the class of the target changed.
\item \code{always}: Whether \code{mode} in \code{\link[=tar_cue]{tar_cue()}} is \code{"always"}.
If \code{TRUE}, \code{\link[=tar_make]{tar_make()}} always runs the target.
\item \code{never}: Whether \code{mode} in \code{\link[=tar_cue]{tar_cue()}} is \code{"never"}.
If \code{TRUE}, \code{\link[=tar_make]{tar_make()}} will only run if the
\code{meta} cue activates.
\item \code{command}: Whether the target's command changed since last time.
Always \code{TRUE} if the \code{meta} cue is activated.
Otherwise, always \code{FALSE} if the \code{command} cue is suppressed.
\item \code{depend}: Whether the data/output of at least one of the target's
dependencies changed since last time.
Dependencies are targets, functions,
and global objects directly upstream.
Call \code{tar_outdated(targets_only = FALSE)} or
\code{tar_visnetwork(targets_only = FALSE)} to see exactly which
dependencies are outdated.
Always \code{NA} if the \code{meta} cue is activated.
Otherwise, always \code{FALSE} if the \code{depend} cue is suppressed.
\item \code{format}: Whether the storage format of the target
is different from last time.
Always \code{NA} if the \code{meta} cue is activated.
Otherwise, always \code{FALSE} if the \code{format} cue is suppressed.
\item \code{repository}: Whether the storage repository of the target
is different from last time.
Always \code{NA} if the \code{meta} cue is activated.
Otherwise, always \code{FALSE} if the \code{format} cue is suppressed.
\item \code{iteration}: Whether the iteration mode of the target
is different from last time.
Always \code{NA} if the \code{meta} cue is activated.
Otherwise, always \code{FALSE} if the \code{iteration} cue is suppressed.
\item \code{file}: Whether the file(s) with the target's return value
are missing or different from last time.
Always \code{NA} if the \code{meta} cue is activated.
Otherwise, always \code{FALSE} if the \code{file} cue is suppressed.
}}

\item{shortcut}{Logical of length 1, how to interpret the \code{names} argument.
If \code{shortcut} is \code{FALSE} (default) then the function checks
all targets upstream of \code{names} as far back as the dependency graph goes.
If \code{TRUE}, then the function only checks the targets in \code{names}
and uses stored metadata for information about upstream dependencies
as needed. \code{shortcut = TRUE} increases speed if there are a lot of
up-to-date targets, but it assumes all the dependencies
are up to date, so please use with caution.
Use with caution. \code{shortcut = TRUE} only works if you set \code{names}.}

\item{reporter}{Character of length 1, name of the reporter to user.
Controls how messages are printed as targets are checked.

The default value of \code{reporter} is the value
returned by \code{tar_config_get("reporter_outdated")}.
The default of \code{tar_config_get("reporter_outdated")} is \code{"terse"}
if the calling R session is either:

\if{html}{\out{<div class="sourceCode">}}\preformatted{  1. Non-interactive (`interactive()` returns `FALSE`), or
  2. Inside a literate programming document
    (the `knitr.in.progress` global option is `TRUE`).
}\if{html}{\out{</div>}}

Otherwise, the default is \code{"balanced"}.
You can always set the reporter manually.
Choices:

\if{html}{\out{<div class="sourceCode">}}\preformatted{* `"balanced"`: a reporter that balances efficiency
  with informative detail.
  Uses a `cli` progress bar instead of printing messages
  for individual dynamic branches.
  To the right of the progress bar is a text string like
  "22.6s, 4510+, 124-" (22.6 seconds elapsed, 4510 targets
  detected as outdated so far,
  124 targets detected as up to date so far).

  For best results with the balanced reporter, you may need to
  adjust your `cli` settings. See global options `cli.num_colors`
  and `cli.dynamic` at
  <https://cli.r-lib.org/reference/cli-config.html>.
  On that page is also the `CLI_TICK_TIME` environment variable
  which controls the time delay between progress bar updates.
  If the delay is too low, then overhead from printing to the console
  may slow down the pipeline.
* `"terse"`: like `"balanced"`, except without a progress bar.
* `"silent"`: print nothing.
}\if{html}{\out{</div>}}}

\item{seconds_reporter}{Deprecated on 2025-03-31
(\code{targets} version 1.10.1.9010).}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}

\item{envir}{An environment, where to run the target R script
(default: \verb{_targets.R}) if \code{callr_function} is \code{NULL}.
Ignored if \code{callr_function} is anything other than \code{NULL}.
\code{callr_function} should only be \code{NULL} for debugging and
testing purposes, not for serious runs of a pipeline, etc.

The \code{envir} argument of \code{\link[=tar_make]{tar_make()}} and related
functions always overrides
the current value of \code{tar_option_get("envir")} in the current R session
just before running the target script file,
so whenever you need to set an alternative \code{envir}, you should always set
it with \code{tar_option_set()} from within the target script file.
In other words, if you call \code{tar_option_set(envir = envir1)} in an
interactive session and then
\code{tar_make(envir = envir2, callr_function = NULL)},
then \code{envir2} will be used.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
A data frame with one row per target/object and one column
per cue. Each element is a logical to indicate whether the cue
is activated for the target.
See the \code{field} argument in this help file for details.
}
\description{
For each target, report which cues are activated.
Except for the \code{never} cue, the target will rerun in \code{\link[=tar_make]{tar_make()}}
if any cue is activated. The target is suppressed if the \code{never}
cue is \code{TRUE}. See \code{\link[=tar_cue]{tar_cue()}} for details.
}
\details{
Caveats:
\itemize{
\item \code{\link[=tar_cue]{tar_cue()}} allows you to change/suppress cues, so the return
value will depend on the settings you supply to \code{\link[=tar_cue]{tar_cue()}}.
\item If a pattern tries to branches over a target that does not exist
in storage, then the branches are omitted from the output.
\item \code{tar_sitrep()} is myopic. It only considers what happens to the
immediate target and its immediate upstream dependencies,
and it makes no attempt to propagate invalidation downstream.
}
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  list(
    tar_target(x, seq_len(2)),
    tar_target(y, 2 * x, pattern = map(x))
  )
}, ask = FALSE)
tar_make()
tar_sitrep()
tar_meta(starts_with("y_")) # see also any_of()
})
}
}
\seealso{
Other inspect: 
\code{\link{tar_deps}()},
\code{\link{tar_manifest}()},
\code{\link{tar_network}()},
\code{\link{tar_outdated}()},
\code{\link{tar_validate}()}
}
\concept{inspect}
