% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ids.R
\name{get_ids}
\alias{get_ids}
\title{Return the accepted taxonomic identifier, \code{acceptedNameUsageID} given a scientific name}
\usage{
get_ids(
  name,
  provider = getOption("tl_default_provider", "itis"),
  version = tl_latest_version(),
  dir = tl_dir()
)
}
\arguments{
\item{name}{character vector of scientific names}

\item{provider}{Abbreviation for a known naming provider.
Provider data should first be imported with \verb{[tl_create]}.
Note: setting provider to \code{"itis_test"} is for testing purposes only,
use \code{"itis"} for the full ITIS data.  See details}

\item{version}{version of the authority to use (e.g. four-digit year)}

\item{dir}{storage location for the LMDB databases}
}
\value{
a vector of matching accepted identifiers.  Note that if the name
provided is considered to be a synonym by the provider, then the ID corresponds
to the accepted name and not the synonym.  (i.e. \code{get_names(get_ids(synonym))})
will return the accepted name and not the synonym name.
}
\description{
Return the accepted taxonomic identifier, \code{acceptedNameUsageID} given a scientific name
}
\examples{

\dontshow{Sys.setenv(TAXALIGHT_HOME=tempfile())}

\donttest{ # slow initial import
sp <- c("Dendrocygna autumnalis", "Dendrocygna bicolor")
get_ids(sp, "itis_test") # use "itis_test" test data for example only 
}

\dontshow{Sys.unsetenv("TAXALIGHT_HOME")}

}
