% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tci_algorithms.R
\name{tci_plasma}
\alias{tci_plasma}
\title{TCI algorithm for plasma targeting}
\usage{
tci_plasma(Ct, pkmod, dtm = 1/6, maxrt = 1200, ...)
}
\arguments{
\item{Ct}{Target plasma concentration}

\item{pkmod}{PK model}

\item{dtm}{Duration of the infusion}

\item{maxrt}{Maximum infusion rate. Defaults to 200 ml/min in reference to the
maximum infusion rate of 1200 ml/h permitted by
existing TCI pumps (e.g. Anestfusor TCI program).}

\item{...}{Arguments passed on to update.pkmod.}
}
\value{
Numeric value
}
\description{
TCI algorithm based on the algorithm described by Jacobs (1990).
}
\examples{
# plasma targeting
my_mod <- pkmod(pars_pk = c(CL = 10, V1 = 10))
tci_plasma(Ct = 2, my_mod)
# update CL parameter
tci_plasma(Ct = 2, my_mod, pars_pk = c(CL = 15))
}
