% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUC_calc_integral.R
\name{AUC_calc_integral}
\alias{AUC_calc_integral}
\title{Calculate the area under a ROC curve (AUC) by trapezoidal integration}
\usage{
AUC_calc_integral(sens, spec)
}
\arguments{
\item{sens}{a numerical vector of sensitivity values within the range of (0, 1).}

\item{spec}{a numerical vector of specificity values within the range of (0, 1).}
}
\value{
It returns AUC as a numerical scalar.
}
\description{
This function reads in a vector of sensitivity and a vector of specificity to calculates
the area under the curve (AUC) by trapezoidal integration.
}
\note{
This function sorts \code{sens} and \code{1-spec} in an increasing order.
     A 0 and 1 will be added to the two ends of the sorted vectors. The Area Under the Curve (AUC) is obtained by trapezoidal
      integration of the area under the piecewise linear curve obtained by connecting
       points in \code{sens} and \code{1-spec}.
}
\keyword{internal}
