% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.x.times.a.year}
\alias{f.x.times.a.year}
\title{Create an \code{X-Times-A-Year} Frequency}
\usage{
f.x.times.a.year(year, x, position)
}
\arguments{
\item{year}{An integer representing the year of the observation.}

\item{x}{An integer representing the number of observations in each year. It should be a positive integer.}

\item{position}{An integer representing the position of the current observation. It should be a positive integer and cannot be larger than \code{x}.}
}
\value{
An object of class \code{ldtf} which is also a list with the following members:
\item{class}{Determines the class of this frequency.}
\item{year}{Determines the \code{year}.}
\item{x}{Determines the value: \code{x}.}
\item{position}{Determines the \code{position}.}
}
\description{
Use this function to create a frequency for time-series data that occurs \code{x} times every year.
}
\details{
In order to use the \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format} \code{"#:#"} (first # is the \code{year} and
the second # is the \code{position}; e.g., 2010:8/12 or 2010:10/10. Note that 2000:0/2 or 2000:13/12 are invalid.
\item \strong{Class Id} \code{"y#"} (the number is the value: \code{x})
}
}
\examples{

xty0 <- f.x.times.a.year(2020, 3, 1)
#      this frequency divides the year 2020 into 3 partitions
#      and refers to the first partition.

xty_value_str <-  as.character(xty0) # this will be '2020:1'.
xty_class_str <- get.class.id(xty0) # this will be 'y3'.

xty_new <- as.frequency("2021:24", "z24")
#     this frequency divides the year 2021 into 24 partitions
#     and refers to the last partition.

# Don't make the following mistakes:
\donttest{
xty_invalid <- try(f.x.times.a.year(2020, 3, 0))
xty_invalid <- try(f.x.times.a.year(2020, 24, 25))
xty_invalid <- try(as.frequency("2021:13", "y12"))
xty_invalid <- try(as.frequency("2021:0", "y1"))
xty_invalid <- try(as.frequency("2021", "y1"))
}

}
