% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{teal_modules}
\alias{teal_modules}
\alias{module}
\alias{teal_module}
\alias{modules}
\alias{format.teal_module}
\alias{format.teal_modules}
\alias{print.teal_module}
\alias{print.teal_modules}
\title{Create \code{teal_module} and \code{teal_modules} objects}
\usage{
module(
  label = "module",
  server = function(id, data, ...) moduleServer(id, function(input, output, session)
    NULL),
  ui = function(id, ...) tags$p(paste0("This module has no UI (id: ", id, " )")),
  filters,
  datanames = "all",
  server_args = NULL,
  ui_args = NULL,
  transformators = list()
)

modules(..., label = character(0))

\method{format}{teal_module}(
  x,
  is_last = FALSE,
  parent_prefix = "",
  what = c("datasets", "properties", "ui_args", "server_args", "decorators",
    "transformators"),
  ...
)

\method{format}{teal_modules}(x, is_root = TRUE, is_last = FALSE, parent_prefix = "", ...)

\method{print}{teal_module}(x, ...)

\method{print}{teal_modules}(x, ...)
}
\arguments{
\item{label}{(\code{character(1)}) Label shown in the navigation item for the module or module group.
For \code{modules()} defaults to \code{"root"}. See \code{Details}.}

\item{server}{(\code{function}) \code{shiny} module with following arguments:
\itemize{
\item \code{id} - \code{teal} will set proper \code{shiny} namespace for this module (see \code{\link[shiny:moduleServer]{shiny::moduleServer()}}).
\item \code{input}, \code{output}, \code{session} - (optional; not recommended) When provided, then \code{\link[shiny:callModule]{shiny::callModule()}}
will be used to call a module. From \code{shiny} 1.5.0, the recommended way is to use
\code{\link[shiny:moduleServer]{shiny::moduleServer()}} instead which doesn't require these arguments.
\item \code{data} (optional) If the server function includes a \code{data} argument, it will receive a reactive
expression containing the \code{teal_data} object.
\item \code{datasets} (optional) When provided, the module will be called with \code{FilteredData} object as the
value of this argument. (See \code{\link[teal.slice:FilteredData]{teal.slice::FilteredData}}).
\item \code{reporter} (optional) When provided, the module will be called with \code{Reporter} object as the value
of this argument. (See \code{\link[teal.reporter:Reporter]{teal.reporter::Reporter}}).
\item \code{filter_panel_api} (optional) When provided, the module will be called with \code{FilterPanelAPI} object
as the value of this argument. (See \code{\link[teal.slice:FilterPanelAPI]{teal.slice::FilterPanelAPI}}).
\item \code{...} (optional) When provided, \code{server_args} elements will be passed to the module named argument
or to the \code{...}.
}}

\item{ui}{(\code{function}) \code{shiny} UI module function with following arguments:
\itemize{
\item \code{id} - \code{teal} will set proper \code{shiny} namespace for this module.
\item \code{...} (optional) When provided, \code{ui_args} elements will be passed to the module named argument
or to the \code{...}.
}}

\item{filters}{(\code{character}) Deprecated. Use \code{datanames} instead.}

\item{datanames}{(\code{character}) Names of the datasets relevant to the item.
There are 2 reserved values that have specific behaviors:
\itemize{
\item The keyword \code{"all"} includes all datasets available in the data passed to the teal application.
\item \code{NULL} hides the sidebar panel completely.
\item If \code{transformators} are specified, their \code{datanames} are automatically added to this \code{datanames}
argument.
}}

\item{server_args}{(named \code{list}) with additional arguments passed on to the server function.}

\item{ui_args}{(named \code{list}) with additional arguments passed on to the UI function.}

\item{transformators}{(\code{list} of \code{teal_transform_module}) that will be applied to transform module's data input.
To learn more check \code{vignette("transform-input-data", package = "teal")}.}

\item{...}{\itemize{
\item For \code{modules()}: (\code{teal_module} or \code{teal_modules}) Objects to wrap into a tab.
\item For \code{format()} and \code{print()}: Arguments passed to other methods.
}}

\item{x}{(\code{teal_module} or \code{teal_modules}) Object to format/print.}

\item{is_last}{(\code{logical(1)}) Whether this is the last item in its parent's children list.
Affects the tree branch character used (L- vs |-)}

\item{parent_prefix}{(\code{character(1)}) The prefix inherited from parent nodes,
used to maintain the tree structure in nested levels}

\item{what}{(\code{character}) Specifies which metadata to display.
Possible values: "datasets", "properties", "ui_args", "server_args", "transformators"}

\item{is_root}{(\code{logical(1)}) Whether this is the root node of the tree. Only used in
format.teal_modules(). Determines whether to show "TEAL ROOT" header}
}
\value{
\code{module()} returns an object of class \code{teal_module}.

\code{modules()} returns an object of class \code{teal_modules}.
}
\description{
Create a nested tab structure to embed modules in a \code{teal} application.
}
\details{
\code{module()} creates an instance of a \code{teal_module} that can be placed in a \code{teal} application.
\code{modules()} shapes the structure of a the application by organizing \code{teal_module} within the navigation panel.
It wraps \code{teal_module} and \code{teal_modules} objects in a \code{teal_modules} object,
which results in a nested structure corresponding to the nested tabs in the final application.

Note that for \code{modules()} \code{label} comes after \code{...}, so it must be passed as a named argument,
otherwise it will be captured by \code{...}.

The labels \code{"global_filters"} and \code{"Report previewer"} are reserved
because they are used by the \code{mapping} argument of \code{\link[=teal_slices]{teal_slices()}}
and the report previewer module \code{\link[=reporter_previewer_module]{reporter_previewer_module()}}, respectively.
}
\section{Restricting datasets used by \code{teal_module}:}{
The \code{datanames} argument controls which datasets are used by the module's server. These datasets,
passed via server's \code{data} argument, are the only ones shown in the module's tab.

When \code{datanames} is set to \code{"all"}, all datasets in the data object are treated as relevant.
However, this may include unnecessary datasets, such as:
\itemize{
\item Proxy variables for column modifications
\item Temporary datasets used to create final ones
\item Connection objects
}

Datasets which name is prefixed in \code{teal_data} by the dot (\code{.}) are not displayed in the \code{teal} application.
Please see the \emph{"Hidden datasets"} section in `vignette("including-data-in-teal-applications").
}

\section{\code{datanames} with \code{transformators}}{
When transformators are specified, their \code{datanames} are added to the module's \code{datanames}, which
changes the behavior as follows:
\itemize{
\item If \code{module(datanames)} is \code{NULL} and the \code{transformators} have defined \code{datanames}, the sidebar
will appear showing the \code{transformators}' datasets, instead of being hidden.
\item If \code{module(datanames)} is set to specific values and any \code{transformator} has \code{datanames = "all"},
the module may receive extra datasets that could be unnecessary
}
}

\examples{
library(shiny)

module_1 <- module(
  label = "a module",
  server = function(id, data) {
    moduleServer(
      id,
      module = function(input, output, session) {
        output$data <- renderDataTable(data()[["iris"]])
      }
    )
  },
  ui = function(id) {
    ns <- NS(id)
    tagList(dataTableOutput(ns("data")))
  },
  datanames = "all"
)

module_2 <- module(
  label = "another module",
  server = function(id) {
    moduleServer(
      id,
      module = function(input, output, session) {
        output$text <- renderText("Another Module")
      }
    )
  },
  ui = function(id) {
    ns <- NS(id)
    tagList(textOutput(ns("text")))
  },
  datanames = NULL
)

modules <- modules(
  label = "modules",
  modules(
    label = "nested modules",
    module_1
  ),
  module_2
)

app <- init(
  data = teal_data(iris = iris),
  modules = modules
)

if (interactive()) {
  shinyApp(app$ui, app$server)
}
mod <- module(
  label = "My Custom Module",
  server = function(id, data, ...) {},
  ui = function(id, ...) {},
  datanames = c("ADSL", "ADTTE"),
  transformators = list(),
  ui_args = list(a = 1, b = "b"),
  server_args = list(x = 5, y = list(p = 1))
)
cat(format(mod))
custom_module <- function(
  label = "label", ui_args = NULL, server_args = NULL,
  datanames = "all", transformators = list(), bk = FALSE
) {
  ans <- module(
    label,
    server = function(id, data, ...) {},
    ui = function(id, ...) {},
    datanames = datanames,
    transformators = transformators,
    ui_args = ui_args,
    server_args = server_args
  )
  attr(ans, "teal_bookmarkable") <- bk
  ans
}

dummy_transformator <- teal_transform_module(
  label = "Dummy Transform",
  ui = function(id) div("(does nothing)"),
  server = function(id, data) {
    moduleServer(id, function(input, output, session) data)
  }
)

plot_transformator <- teal_transform_module(
  label = "Plot Settings",
  ui = function(id) div("(does nothing)"),
  server = function(id, data) {
    moduleServer(id, function(input, output, session) data)
  }
)

static_decorator <- teal_transform_module(
  label = "Static decorator",
  server = function(id, data) {
    moduleServer(id, function(input, output, session) {
      reactive({
        req(data())
        within(data(), {
          plot <- plot +
            ggtitle("This is title") +
            xlab("x axis")
        })
      })
    })
  }
)

complete_modules <- modules(
  custom_module(
    label = "Data Overview",
    datanames = c("ADSL", "ADAE", "ADVS"),
    ui_args = list(
      view_type = "table",
      page_size = 10,
      filters = c("ARM", "SEX", "RACE"),
      decorators = list(static_decorator)
    ),
    server_args = list(
      cache = TRUE,
      debounce = 1000,
      decorators = list(static_decorator)
    ),
    transformators = list(dummy_transformator),
    bk = TRUE
  ),
  modules(
    label = "Nested 1",
    custom_module(
      label = "Interactive Plots",
      datanames = c("ADSL", "ADVS"),
      ui_args = list(
        plot_type = c("scatter", "box", "line"),
        height = 600,
        width = 800,
        color_scheme = "viridis"
      ),
      server_args = list(
        render_type = "svg",
        cache_plots = TRUE
      ),
      transformators = list(dummy_transformator, plot_transformator),
      bk = TRUE
    ),
    modules(
      label = "Nested 2",
      custom_module(
        label = "Summary Statistics",
        datanames = "ADSL",
        ui_args = list(
          stats = c("mean", "median", "sd", "range"),
          grouping = c("ARM", "SEX")
        )
      ),
      modules(
        label = "Labeled nested modules",
        custom_module(
          label = "Subgroup Analysis",
          datanames = c("ADSL", "ADAE"),
          ui_args = list(
            subgroups = c("AGE", "SEX", "RACE"),
            analysis_type = "stratified"
          ),
          bk = TRUE
        )
      ),
      modules(custom_module(label = "Subgroup Analysis in non-labled modules"))
    )
  ),
  custom_module("Non-nested module")
)

cat(format(complete_modules))
cat(format(complete_modules, what = c("ui_args", "server_args", "transformators")))
cat(format(complete_modules, what = c("decorators", "transformators")))
}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqagSgB0ItMnGYFStAG5wABAB4AtNIBmAVwhjaJdj2kAVLAFUAogIF0mLDgGcAFkNb8IAmEQAmK6nAD6ARjmKXd092AWlpaih6OGppAF5pPhRpQI84RNxQ6SsRKUY45TUNLVpXXGlXKFIoHRBMsJTPAGUckRCIMI7pEoz2zuS3VPzVdXFiiFQVUjKiSYmprLgrK00IGrq+mdI5gBIKqv9pRgpXEQARSqhdSOC9qG1gYETaRlorRIBdd8c+6QBfde+fx6YRUtCGhVGEHYJTWvTCECsBwAco1oa5AWEqgBzAAyr1I7FuV3ongA8rNJuwESEwLdEjwGZlfsDyhdoPBEfFEtxqIkBI5nANPF4AEwHBpwNphCJRGJclAQIikGwifpBNJ4TLZRi5cEjFZo2GdCXNHWtdZhboWtWDeLDIpQoRzaYU+bZJYrI0-aSbHbkAAepAORwgJ0YujggZpAEFFcrVQBZIUajEdf5w6SA5mZUF6h2G6S1DMI5GomHrbF4qwEgOkclbSnUxK1+mM3rZ3q3dmLfJIgw4nH80wQCWIhQ2zxWKXhSLRfKJUfpTKj6fS2dyhKQRbkVwTxZLjMS3yZHgso8iodOaDoA5CWgEzK3fJcaheW7Ql6crqf0-L5NfxdVmHWglGkaFhFEcQpG0L1bHsaN0HYNBUG2UEymQ7ZtVyRxfjAX53iAA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqagSgB0ItMnGYFStAG5wABAB4AtNIBmAVwhjaJdj2kAVLAFUAogIF0mLDgGcAFkNb8IAmEQAmK6nAD6ARjmKXd092AWlpaih6OGppAF5pPhRpQI84RNxQ6SsRKUY45TUNLVpXXGlXKFIoHRBMsJTPAGUckRCIMI7pEoz2zuS3VPzVdXFiiFQVUjKiSYmprLgrK00IGrq+mdI5gBIKqv9pRgpXEQARSqhdSOC9qG1gYETaRlorRIBdd8c+6QBfde+fx6YRUtCGhVGEHYJTWvTCECsBwAco1oa5AWEqgBzAAyr1I7FuV3ongA8rNJuwESEwLdEjwGZlfsDyhdoPBEfFEtxqIkBI5nANPF4AEwHBpwNphCJRGJclAQIikGwifpBNJ4TLZRi5cEjFZo2GdCXNHWtdZhboWtWDeLDIpQoRzaYU+bZJYrI0-aSbHbkAAepAORwgJ0YujggZpAEFFcrVQBZIUajEdf5w6SA5mZUF6h2G6S1DMI5GomHrbF4qwEgOkclbSnUxK1+mM3rZ3q3dmLfJIgw4nH80wQCWIhQ2zxWKXhSLRfKJUfpTKj6fS2dyhKQRbkVwTxZLjMS3yZHgso8iodOaDoA5CWgEzK3fJcaheW7Ql6crqf0-L5NfxdVmHWglGkaFhFEcQpG0L1bHsaN0HYNBUG2UEymQ7ZtVyRxfjAX53iAA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

