% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{blanked_detects}
\alias{blanked_detects}
\title{Example Multi-blanked Detection Data}
\format{
## `blanked_detects`
A data frame with 44,630 rows and 9 columns:
\describe{
 \item{fish_type}{Generally a strain, run, and species of fish (e.g.
  Nimbus Fall Chinook = Fall-run Chinook Salmon from Nimbus Hatchery)}
 \item{Tag_Code}{The hexadecimal acoustic tag ID code}
 \item{mbp_n}{the maximum blanking period used to create this event}
 \item{event_change}{An increasing number which identifies the event number;
  one event per fish per site for all detections which occur within `mbp_n`
  seconds of the next.}
 \item{receiver_general_location}{The more general geographic name of the
  location of the receiver}
 \item{start_time}{The Date and Time of the first detection within the event}
 \item{end_time}{The Date and Time of the last detection within the event}
 \item{n_det}{The total number of detections contained within the event}
 \item{duration}{the total length of time of the event in seconds}
}
}
\usage{
blanked_detects
}
\description{
An example dataset of real acoustic telemetry detections of fish at several
receivers within the California Central Valley from 2021. These detections
have already been been processed using `blanking_event()` to create events
using maximum blanking periods from 3 to 1,500 seconds to reprocess the data.
Each row represents a single event which includes >=1 detection(s) per fish
per site which occur within the specified maximum blanking period `mbp_n`.
}
\keyword{datasets}
