% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TEMPTED.R
\name{svd_centralize}
\alias{svd_centralize}
\title{Remove the mean structure of the temporal tensor}
\usage{
svd_centralize(datlist, r = 1)
}
\arguments{
\item{datlist}{A length n list of matrices.
Each matrix represents a subject,
with columns representing samples from this subject,
the first row representing the sampling time points,
and the following rows representing the feature values.}

\item{r}{The number of ranks in the mean structure. Default is 1.}
}
\value{
A list of results.
\describe{
\item{datlist}{The new temporal tensor after mean structure is removed.}
\item{A_tilde}{The subject singular vector of the mean structure, a subject by r matrix.}
\item{B_tilde}{The feature singular vector of the mean structure, a feature by r matrix.}
\item{lambda_tilde}{The singular value of the mean structure, a length r vector.}
}
}
\description{
This function first average the feature value of all time points for each subject to form a subject by feature matrix.
Next, it performs a singular value decomposition of this matrix and construct the matrix's rank-r approximation.
Then, it subtracts this rank-r subject by feature matrix from the temporal tensor.
}
\references{
Shi P, Martino C, Han R, Janssen S, Buck G, Serrano M, Owzar K, Knight R, Shenhav L, Zhang AR. (2023) \emph{Time-Informed Dimensionality Reduction for Longitudinal Microbiome Studies}. bioRxiv. doi: 10.1101/550749. \url{https://www.biorxiv.org/content/10.1101/550749}.
}
\seealso{
Examples can be found in \code{\link{tempted}}.
}
