% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normFiberCentering}
\alias{normFiberCentering}
\title{Preprocessing: fiber Centering}
\usage{
normFiberCentering(Y, o)
}
\arguments{
\item{Y}{the tensor data. See function \code{\link{tensorBF}} for
details.}

\item{o}{the \eqn{o^{th}} (default: 1) mode of the tensor in which the fibers are to be centered to zero mean.}
}
\value{
a list containing the following elements:
\item{data}{The data after performing the required centering operation.}
\item{pre}{The centering values used for preprocessing.}
}
\description{
\code{normFiberCentering} center the fibers of the \eqn{o^{th}} mode of the tensor to zero mean.
}
\examples{
#Data generation
K <- 3
X <- matrix(rnorm(20*K),20,K)
W <- matrix(rnorm(30*K),30,K)
U <- matrix(rnorm(3*K),3,K)
Y = 0
for(k in 1:K) Y <- Y + outer(outer(X[,k],W[,k]),U[,k])
 Y <- Y + array(rnorm(20*30*3),dim=c(20,30,3))

#center the fibers in first mode of tensor Y
res <- normFiberCentering(Y=Y,o=1)
dim(res$data) #the centered data
}
\references{
Kolda, Tamara G., and Brett W. Bader. "Tensor decompositions and applications." SIAM review 51.3 (2009): 455-500.
}
