% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_tensor.R
\name{mat}
\alias{mat}
\title{Unfold a matrix.}
\usage{
mat(A, k)
}
\arguments{
\item{A}{An array to be unfolded.}

\item{k}{The mode, or dimension, along which the unfolding is to be applied.}
}
\value{
A matrix  whose rows  index the  \eqn{k}th mode  and whose columns
  index every other mode.  The ordering of the columns is in lexicographical
  order of the indices of the array \eqn{A}.
}
\description{
\code{mat} returns a matrix version of a provided tensor.
}
\details{
Applies the matrix unfolding operator (also called 'matricization' or 'matrix
flattening' operator) on a provided tensor. There are multiple ways one could
do this. This function performs the matrix unfolding described in
Kolda and Bader (2009).
}
\examples{
A <- array(1:8, dim = c(2,2,2))
mat(A, 1)
mat(A, 2)
mat(A, 3)
}
\references{
\itemize{
  \item{Kolda, T. G., & Bader, B. W. (2009). Tensor decompositions and applications. \emph{SIAM review}, 51(3), 455-500 \doi{10.1137/07070111X}.}
}
}
\author{
Peter Hoff.
}
