% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styling.R
\name{style_pkg}
\alias{style_pkg}
\title{Style a package}
\usage{
style_pkg(
  path = ".",
  config_file = "tergo.toml",
  configuration = list(),
  force = FALSE,
  extensions = c(".R", ".r"),
  verbose = interactive()
)
}
\arguments{
\item{path}{(\code{character}) The path to the package. Default \code{"."}.}

\item{config_file}{(\code{character}) The path to the configuration file. Default \code{"tergo.toml"}.}

\item{configuration}{(\code{list}) Configuration for formatting. Default \code{list()}.}

\item{force}{(\code{logical(1)}) Whether to format the files even
if no package was found. \code{TRUE} - format the \code{.R} and \code{.r} files
found in the directory (recursive). \code{FALSE} exit without formatting
anything. Default \code{FALSE}.}

\item{extensions}{(\code{character}) The extensions of the files to format. Default \code{c(".R", ".r")}.}

\item{verbose}{(\code{logical(1)}) Whether per file status and run statistics should be printed. Default \code{interactive()}.}
}
\value{
No return values, called for side effects.
}
\description{
Style a package
}
\details{
Configuration is read from a file named \code{tergo.toml} in the root of the
package. The precedence of the configuration is (from the highest to lowest):
\enumerate{
\item The configuration passed to the function.
\item The configuration file.
}

To see possible configuration options, see \code{\link[=get_default_config]{get_default_config()}}.
}
\examples{
style_pkg()
style_pkg(path = "./tergo", config_file = "custom_tergo.toml", verbose = TRUE)

}
