% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testthat.R
\name{with_srcref}
\alias{with_srcref}
\title{Raise \code{testthat} Expectations With A Known Source Reference}
\usage{
with_srcref(src, expr, envir = parent.frame())
}
\arguments{
\item{src}{A \code{srcref_key} which is parsed to produce an artificial \code{\link{srcref}}
for the expectation signaled messages.}

\item{expr}{An expression to be evaluated. If an \code{expectation} condition is
raised during its evaluation, its \code{\link{srcref}} is converted to \code{src}.}

\item{envir}{An environment in which to evaluate \code{expr}.}
}
\value{
The result of evaluating \code{expr}, or an expectation with appended
\code{\link{srcref}} information if an expectation is raised.
}
\description{
Retroactively assigns a source file and location to a expectation. This
allows \code{testthat} to report an origin for any code that raised an example
test failure from the source \code{roxygen2} code, even though the test code is
reconstructed from package documentation files.
}
