% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.table.R
\name{str_stopwords_by_part_of_speech}
\alias{str_stopwords_by_part_of_speech}
\title{Create a vector of English words associated with particular parts of speech.}
\usage{
str_stopwords_by_part_of_speech(
  parts = c("adjective", "adverb", "conjunction", "definite article", "interjection",
    "noun", "noun phrase", "plural", "preposition", "pronoun", "verb (intransitive)",
    "verb (transitive)", "verb (usu participle)"),
  include_multi_word = FALSE
)
}
\arguments{
\item{parts}{A vector, at least one of the following:
'adjective',
'adverb',
'conjunction',
'definite article',
'interjection',
'noun',
'noun phrase',
'plural',
'preposition',
'pronoun',
'verb (intransitive)',
'verb (transitive)',
'verb (usu participle)'}

\item{include_multi_word}{TRUE/FALSE, if TRUE, includes records from the pos data.table where multi_word == TRUE, otherwise excludes these records.}
}
\value{
A vector of words matching the part of speech shown in the data.table pos.
}
\description{
Create a vector of English words associated with particular parts of speech.
}
\examples{
str_stopwords_by_part_of_speech('adjective')
}
