% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_names.R
\name{replace_names}
\alias{replace_names}
\title{Replace First/Last Names}
\usage{
replace_names(x, names = textclean::drop_element(gsub("(^.)(.*)",
  "\\\\U\\\\1\\\\L\\\\2", c(lexicon::freq_last_names[[1]],
  lexicon::common_names), perl = TRUE), "^([AIU]n|[TSD]o|H[ea]Pa|Oh)$"),
  replacement = "", ...)
}
\arguments{
\item{x}{The text variable.}

\item{names}{A vector of names to replace.  This may be made more custom 
through a vector provided from a named entity extractor.}

\item{replacement}{A string to replace names with.}

\item{\dots}{Other arguments passed to 
\code{\link[textclean]{replace_tokens}}.}
}
\value{
Returns a vector with names replaced.
}
\description{
Replaces first/last names.
}
\examples{
x <- c(
    "Mary Smith is not here",
    "Karen is not a nice person",
    "Will will do it",
    NA
) 

replace_names(x)
replace_names(x, replacement = '<<NAME>>')
}
