% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_ops.R
\name{crf_multitag_sequence_score}
\alias{crf_multitag_sequence_score}
\title{CRF multitag sequence score}
\usage{
crf_multitag_sequence_score(
  inputs,
  tag_bitmap,
  sequence_lengths,
  transition_params
)
}
\arguments{
\item{inputs}{A [batch_size, max_seq_len, num_tags] tensor of unary potentials
to use as input to the CRF layer.}

\item{tag_bitmap}{A [batch_size, max_seq_len, num_tags] boolean tensor representing
all active tags at each index for which to calculate the unnormalized score.}

\item{sequence_lengths}{A [batch_size] vector of true sequence lengths.}

\item{transition_params}{A [num_tags, num_tags] transition matrix.}
}
\value{
sequence_scores: A [batch_size] vector of unnormalized sequence scores.
}
\description{
Computes the unnormalized score of all tag sequences matching
}
\details{
tag_bitmap. tag_bitmap enables more than one tag to be considered
correct at each time
step. This is useful when an observed output at a given time step is
consistent with more than one tag, and thus the log likelihood of that
observation must take into account all possible consistent tags. Using
one-hot vectors in tag_bitmap gives results identical to
crf_sequence_score.
}
