% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_ops_.R
\name{img_matrices_to_flat_transforms}
\alias{img_matrices_to_flat_transforms}
\title{Matrices to flat transforms}
\usage{
img_matrices_to_flat_transforms(transform_matrices, name = NULL)
}
\arguments{
\item{transform_matrices}{One or more affine transformation matrices, for the
reverse transformation in homogeneous coordinates. Shape `c(3, 3)` or `c(N, 3, 3)`.}

\item{name}{The name for the op.}
}
\value{
2D tensor of flat transforms with shape `(N, 8)`, which may be passed into `transform` op.
}
\description{
Converts affine matrices to projective transforms.
}
\details{
Note that we expect matrices that map output coordinates to input
coordinates. To convert forward transformation matrices,
call `tf$linalg$inv` on the matrices and use the result here.
}
\section{Raises}{

ValueError: If `transform_matrices` have an invalid shape.
}

