% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/losses.R
\name{loss_triplet_semihard}
\alias{loss_triplet_semihard}
\title{Triplet semihard loss}
\usage{
loss_triplet_semihard(margin = 1, name = NULL, ...)
}
\arguments{
\item{margin}{Float, margin term in the loss definition. Default value is 1.0.}

\item{name}{Optional name for the op.}

\item{...}{additional arguments to pass}
}
\value{
triplet_loss: float scalar with dtype of y_pred.
}
\description{
Computes the triplet loss with semi-hard negative mining.
}
\examples{

\dontrun{
model = keras_model_sequential() \%>\%
  layer_conv_2d(filters = 64, kernel_size = 2, padding='same', input_shape=c(28,28,1)) \%>\%
  layer_max_pooling_2d(pool_size=2) \%>\%
  layer_flatten() \%>\%
  layer_dense(256, activation= NULL) \%>\%
  layer_lambda(f = function(x) tf$math$l2_normalize(x, axis = 1L))

model \%>\% compile(
  optimizer = optimizer_lazy_adam(),
  # apply triplet semihard loss
  loss = loss_triplet_semihard())
}


}
