% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metrics_f1score}
\alias{metrics_f1score}
\title{F1Score}
\usage{
metrics_f1score(
  num_classes,
  average = NULL,
  threshold = NULL,
  name = "f1_score",
  dtype = tf$float32
)
}
\arguments{
\item{num_classes}{Number of unique classes in the dataset.}

\item{average}{Type of averaging to be performed on data. Acceptable values are NULL,
micro, macro and weighted. Default value is NULL.
- None: Scores for each class are returned
- micro: True positivies, false positives and false negatives are computed globally.
- macro: True positivies, false positives and
- false negatives are computed for each class and their unweighted mean is returned.
- weighted: Metrics are computed for each class and returns the mean weighted by the number of
true instances in each class.}

\item{threshold}{Elements of y_pred above threshold are considered to be 1, and the rest 0.
If threshold is NULL, the argmax is converted to 1, and the rest 0.}

\item{name}{(optional) String name of the metric instance.}

\item{dtype}{(optional) Data type of the metric result. Defaults to `tf$float32`.}
}
\value{
F-1 Score: float
}
\description{
Computes F-1 Score.
}
\details{
It is the harmonic mean of precision and recall.
Output range is [0, 1]. Works for both multi-class
and multi-label classification. F-1 = 2 * (precision * recall) / (precision + recall)
}
\section{Raises}{

ValueError: If the `average` has values other than [NULL, micro, macro, weighted].
}

\examples{

\dontrun{
model = keras_model_sequential() \%>\%
  layer_dense(units = 10, input_shape = ncol(iris) - 1,activation = activation_lisht) \%>\%
  layer_dense(units = 3)

model \%>\% compile(loss = 'categorical_crossentropy',
                  optimizer = optimizer_radam(),
                  metrics = metrics_f1score(3))
}

}
