% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_ucarima.R
\name{as.ucarima.um}
\alias{as.ucarima.um}
\title{Coerce a Univariate Model to UCARIMA form}
\usage{
\method{as.ucarima}{um}(
  object,
  ar = NULL,
  i = NULL,
  single = FALSE,
  canonical = FALSE,
  cwfact = c("roots", "iter", "best"),
  pfrac = c("gcd", "solve"),
  tol = 1e-05,
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{object}{An object of class \code{"um"}.}

\item{ar}{Autoregressive lag polynomial for the signal component.}

\item{i}{Integration lag polynomial for the signal component.}

\item{single}{Logical. If \code{TRUE}, extracts a single component; if
\code{FALSE}, extracts multiple components.}

\item{canonical}{Logical. If \code{TRUE}, applies the canonical decomposition
constraint.}

\item{cwfact}{Method for Cramer-Wold factorization: \code{"roots"} polynomial
(Godolphin 1976), \code{"wilson"} iterative algorithm (Wilson 1969), or the
\code{"best"} of both methods.}

\item{pfrac}{Method for partial fraction decomposition: \code{"gcd"}
(extended Euclidean algorithm) or \code{"solve"} (linear system solver).}

\item{tol}{Numerical tolerance for zero and unit values. Default is
\code{1e-5}.}

\item{envir}{Environment for evaluation.}

\item{...}{Additional arguments.}
}
\description{
Converts an object of class \code{"um"} (univariate model) to its equivalent
\code{"ucarima"} representation, i.e., the ARIMA-model-based decomposition of
unobserved components (trend, seasonal, cycle, irregular, etc.) implied by
the univariate ARIMA structure, following the approach of Hillmer and Tiao
(1982).
}
\details{
The UCARIMA decomposition expresses a univariate ARIMA model as the
sum of independent component ARIMA models (trend, seasonal, cycle, irregular,
etc.) obtained through the factorization of its spectral density. This
provides a model-based interpretation of signal extraction and seasonal
adjustment.
}
\references{
Hillmer, S. C., & Tiao, G. C. (1982). An ARIMA-model-based
approach to seasonal adjustment. \emph{Journal of the American Statistical
Association}, \strong{77}(377), 63–70.

Burman, J. P. (1980). Seasonal adjustment by signal extraction. \emph{Journal
of the Royal Statistical Society: Series A}, \strong{143}(3), 321–337.

Godolphin, E. J. (1976). On the Cramer–Wold factorization. \emph{Biometrika},
\strong{63}(2), 367–372. \doi{10.1093/biomet/63.2.367}

Tunnicliffe Wilson, G. (1969). Factorization of the covariance generating
function of a pure moving average process. \emph{SIAM Journal on Numerical
Analysis}, \strong{6}(1), 1–7. \doi{10.1137/0706001}
}
\seealso{
\code{\link{ucarima}}
}
