% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfm.R
\name{coef.tfm}
\alias{coef.tfm}
\title{Coefficients of a Transfer Function Model}
\usage{
\method{coef}{tfm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{tfm}.}

\item{...}{Further arguments (currently unused).}
}
\value{
A named numeric vector with the estimated coefficients of the model, 
including regression coefficients, transfer function parameters, and noise 
model parameters.
}
\description{
Extracts the estimated coefficients from a fitted transfer function model 
of class \code{tfm}. This is a method for the generic \code{\link{coef}} 
function.
}
\examples{
\dontrun{
mdl <- tfm(y, xreg = X, noise = um())
coef(mdl)
}
}
\seealso{
\code{\link{tfm}}
}
