% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ucarima.R, R/um.R
\name{phi.ucarima}
\alias{phi.ucarima}
\alias{phi}
\alias{phi.um}
\title{Unscramble AR polynomial}
\usage{
\method{phi}{ucarima}(x, i = NULL, ar = TRUE, lp = TRUE, ...)

phi(x, ...)

\method{phi}{um}(x, ...)
}
\arguments{
\item{x}{an object of class \code{um}.}

\item{i}{integer. Omit this component model.}

\item{ar}{logical. If TRUE, the common AR polynomial is included.}

\item{lp}{logical indicating the type of return: \code{\link{lagpol}} object
or numeric vector.}

\item{...}{additional arguments.}
}
\value{
A numeric vector \code{c(1, a1, ..., ad)}
}
\description{
\code{phi} multiplies the AR polynomials of an object of 
the \code{um} class.
}
\note{
This function returns the member variable \code{um$phi}.
}
\examples{
um1 <- um(ar = "(1 - 0.8B)(1 - 0.5B)")
phi(um1)

}
