% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsing_utils.R
\name{classifier_parse_example_spec}
\alias{classifier_parse_example_spec}
\title{Generates Parsing Spec for TensorFlow Example to be Used with Classifiers}
\usage{
classifier_parse_example_spec(
  feature_columns,
  label_key,
  label_dtype = tf$int64,
  label_default = NULL,
  weight_column = NULL
)
}
\arguments{
\item{feature_columns}{An iterable containing all feature columns. All items
should be instances of classes derived from \verb{_FeatureColumn}.}

\item{label_key}{A string identifying the label. It means \code{tf$Example} stores
labels with this key.}

\item{label_dtype}{A \code{tf$dtype} identifies the type of labels. By default it
is \code{tf$int64}. If user defines a \code{label_vocabulary}, this should be set as
\code{tf$string}. \code{tf$float32} labels are only supported for binary
classification.}

\item{label_default}{used as label if label_key does not exist in given
\code{tf$Example}. An example usage: let's say \code{label_key} is 'clicked' and
\code{tf$Example} contains clicked data only for positive examples in following
format \verb{key:clicked, value:1}. This means that if there is no data with key
'clicked' it should count as negative example by setting
\code{label_deafault=0}. Type of this value should be compatible with
\code{label_dtype}.}

\item{weight_column}{A string or a numeric column created by
\code{\link[=column_numeric]{column_numeric()}} defining feature column representing
weights. It is used to down weight or boost examples during training. It
will be multiplied by the loss of the example. If it is a string, it is
used as a key to fetch weight tensor from the \code{features}. If it is a
numeric column, raw tensor is fetched by key \code{weight_column$key}, then
\code{weight_column$normalizer_fn} is applied on it to get weight tensor.}
}
\value{
A dict mapping each feature key to a \code{FixedLenFeature} or
\code{VarLenFeature} value.
}
\description{
If users keep data in TensorFlow Example format, they need to call \code{tf$parse_example}
with a proper feature spec. There are two main things that this utility
helps:
\itemize{
\item Users need to combine parsing spec of features with labels and
weights (if any) since they are all parsed from same \code{tf$Example} instance.
This utility combines these specs.
\item It is difficult to map expected label by
a classifier such as \code{dnn_classifier} to corresponding \code{tf$parse_example} spec.
This utility encodes it by getting related information from users (key,
dtype).
}
}
\section{Raises}{

\itemize{
\item ValueError: If label is used in \code{feature_columns}.
\item ValueError: If weight_column is used in \code{feature_columns}.
\item ValueError: If any of the given \code{feature_columns} is not a feature column instance.
\item ValueError: If \code{weight_column} is not a numeric column instance.
\item ValueError: if label_key is \code{NULL}.
}
}

\seealso{
Other parsing utilities: 
\code{\link{regressor_parse_example_spec}()}
}
\concept{parsing utilities}
