% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{layer_dense_variational}
\alias{layer_dense_variational}
\title{Dense Variational Layer}
\usage{
layer_dense_variational(
  object,
  units,
  make_posterior_fn,
  make_prior_fn,
  kl_weight = NULL,
  kl_use_exact = FALSE,
  activation = NULL,
  use_bias = TRUE,
  ...
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{units}{Positive integer, dimensionality of the output space.}

\item{make_posterior_fn}{function taking \code{tf$size(kernel)},
\code{tf$size(bias)}, \code{dtype} and returns another callable which takes an
input and produces a \code{tfd$Distribution} instance.}

\item{make_prior_fn}{function taking \code{tf$size(kernel)}, \code{tf$size(bias)},
\code{dtype} and returns another callable which takes an input and produces a
\code{tfd$Distribution} instance.}

\item{kl_weight}{Amount by which to scale the KL divergence loss between prior
and posterior.}

\item{kl_use_exact}{Logical indicating that the analytical KL divergence
should be used rather than a Monte Carlo approximation.}

\item{activation}{An activation function.  See \code{keras::layer_dense}. Default: \code{NULL}.}

\item{use_bias}{Whether or not the dense layers constructed in this layer
should have a bias term.  See \code{keras::layer_dense}.  Default: \code{TRUE}.}

\item{...}{Additional keyword arguments passed to the \code{keras::layer_dense} constructed by this layer.}
}
\value{
a Keras layer
}
\description{
This layer uses variational inference to fit a "surrogate" posterior to the
distribution over both the \code{kernel} matrix and the \code{bias} terms which are
otherwise used in a manner similar to \code{layer_dense()}.
This layer fits the "weights posterior" according to the following generative
process:

\if{html}{\out{<div class="sourceCode none">}}\preformatted{[K, b] ~ Prior()
M = matmul(X, K) + b
Y ~ Likelihood(M)
}\if{html}{\out{</div>}}
}
\seealso{
Other layers: 
\code{\link{layer_autoregressive}()},
\code{\link{layer_conv_1d_flipout}()},
\code{\link{layer_conv_1d_reparameterization}()},
\code{\link{layer_conv_2d_flipout}()},
\code{\link{layer_conv_2d_reparameterization}()},
\code{\link{layer_conv_3d_flipout}()},
\code{\link{layer_conv_3d_reparameterization}()},
\code{\link{layer_dense_flipout}()},
\code{\link{layer_dense_local_reparameterization}()},
\code{\link{layer_dense_reparameterization}()},
\code{\link{layer_variable}()}
}
\concept{layers}
