% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts.R
\name{sts_additive_state_space_model}
\alias{sts_additive_state_space_model}
\title{A state space model representing a sum of component state space models.}
\usage{
sts_additive_state_space_model(
  component_ssms,
  constant_offset = 0,
  observation_noise_scale = NULL,
  initial_state_prior = NULL,
  initial_step = 0,
  validate_args = FALSE,
  allow_nan_stats = TRUE,
  name = NULL
)
}
\arguments{
\item{component_ssms}{\code{list} containing one or more
\code{tfd_linear_gaussian_state_space_model} instances. The components
will in general implement different time-series models, with possibly
different \code{latent_size}, but they must have the same \code{dtype}, event
shape (\code{num_timesteps} and \code{observation_size}), and their batch shapes
must broadcast to a compatible batch shape.#'}

\item{constant_offset}{scalar \code{float} \code{tensor}, or batch of scalars,
specifying a constant value added to the sum of outputs from the
component models. This allows the components to model the shifted series
\code{observed_time_series - constant_offset}. Default value: \code{0}.#'}

\item{observation_noise_scale}{Optional scalar \code{float} \code{tensor} indicating the
standard deviation of the observation noise. May contain additional
batch dimensions, which must broadcast with the batch shape of elements
in \code{component_ssms}. If \code{observation_noise_scale} is specified for the
\code{sts_additive_state_space_model}, the observation noise scales of component
models are ignored. If \code{NULL}, the observation noise scale is derived
by summing the noise variances of the component models, i.e.,
\verb{observation_noise_scale = sqrt(sum([ssm.observation_noise_scale**2 for ssm in component_ssms]))}.}

\item{initial_state_prior}{instance of \code{tfd_multivariate_normal}
representing the prior distribution on latent states.  Must have
event shape \verb{[1]} (as \code{tfd_linear_gaussian_state_space_model} requires a
rank-1 event shape).}

\item{initial_step}{Optional scalar \code{integer} \code{tensor} specifying the starting
timestep. Default value: 0.}

\item{validate_args}{\code{logical}. Whether to validate input
with asserts. If \code{validate_args} is \code{FALSE}, and the inputs are
invalid, correct behavior is not guaranteed. Default value: \code{FALSE}.}

\item{allow_nan_stats}{\code{logical}. If \code{FALSE}, raise an
exception if a statistic (e.g. mean/mode/etc...) is undefined for any
batch member. If \code{TRUE}, batch members with valid parameters leading to
undefined statistics will return NaN for this statistic. Default value: \code{TRUE}.}

\item{name}{string prefixed to ops created by this class.
Default value: "AdditiveStateSpaceModel".}
}
\value{
an instance of \code{LinearGaussianStateSpaceModel}.
}
\description{
A state space model (SSM) posits a set of latent (unobserved) variables that
evolve over time with dynamics specified by a probabilistic transition model
\code{p(z[t+1] | z[t])}. At each timestep, we observe a value sampled from an
observation model conditioned on the current state, \code{p(x[t] | z[t])}. The
special case where both the transition and observation models are Gaussians
with mean specified as a linear function of the inputs, is known as a linear
Gaussian state space model and supports tractable exact probabilistic
calculations; see \code{tfd_linear_gaussian_state_space_model} for details.
}
\details{
The \code{sts_additive_state_space_model} represents a sum of component state space
models. Each of the \code{N} components describes a random process
generating a distribution on observed time series \verb{x1[t], x2[t], ..., xN[t]}.
The additive model represents the sum of these
processes, \code{y[t] = x1[t] + x2[t] + ... + xN[t] + eps[t]}, where
\code{eps[t] ~ N(0, observation_noise_scale)} is an observation noise term.

Mathematical Details

The additive model concatenates the latent states of its component models.
The generative process runs each component's dynamics in its own subspace of
latent space, and then observes the sum of the observation models from the
components.

Formally, the transition model is linear Gaussian:

\if{html}{\out{<div class="sourceCode">}}\preformatted{p(z[t+1] | z[t]) ~ Normal(loc = transition_matrix.matmul(z[t]), cov = transition_cov)
}\if{html}{\out{</div>}}

where each \code{z[t]} is a latent state vector concatenating the component
state vectors, \verb{z[t] = [z1[t], z2[t], ..., zN[t]]}, so it has size
\verb{latent_size = sum([c.latent_size for c in components])}.

The transition matrix is the block-diagonal composition of transition
matrices from the component processes:

\if{html}{\out{<div class="sourceCode">}}\preformatted{transition_matrix =
 [[ c0.transition_matrix,  0.,                   ..., 0.                   ],
  [ 0.,                    c1.transition_matrix, ..., 0.                   ],
  [ ...                    ...                   ...                       ],
  [ 0.,                    0.,                   ..., cN.transition_matrix ]]
}\if{html}{\out{</div>}}

and the noise covariance is similarly the block-diagonal composition of
component noise covariances:

\if{html}{\out{<div class="sourceCode">}}\preformatted{transition_cov =
 [[ c0.transition_cov, 0.,                ..., 0.                ],
  [ 0.,                c1.transition_cov, ..., 0.                ],
  [ ...                ...                     ...               ],
  [ 0.,                0.,                ..., cN.transition_cov ]]
}\if{html}{\out{</div>}}

The observation model is also linear Gaussian,

\if{html}{\out{<div class="sourceCode">}}\preformatted{p(y[t] | z[t]) ~ Normal(loc = observation_matrix.matmul(z[t]), stddev = observation_noise_scale)
}\if{html}{\out{</div>}}

This implementation assumes scalar observations, so \code{observation_matrix} has shape \verb{[1, latent_size]}.
The additive observation matrix simply concatenates the observation matrices from each component:

\if{html}{\out{<div class="sourceCode">}}\preformatted{observation_matrix = concat([c0.obs_matrix, c1.obs_matrix, ..., cN.obs_matrix], axis=-1)
}\if{html}{\out{</div>}}

The effect is that each component observation matrix acts on the dimensions
of latent state corresponding to that component, and the overall expected
observation is the sum of the expected observations from each component.

If \code{observation_noise_scale} is not explicitly specified, it is also computed
by summing the noise variances of the component processes:

\if{html}{\out{<div class="sourceCode">}}\preformatted{observation_noise_scale = sqrt(sum([c.observation_noise_scale**2 for c in components]))
}\if{html}{\out{</div>}}
}
\seealso{
Other sts: 
\code{\link{sts_autoregressive}()},
\code{\link{sts_autoregressive_state_space_model}()},
\code{\link{sts_constrained_seasonal_state_space_model}()},
\code{\link{sts_dynamic_linear_regression}()},
\code{\link{sts_dynamic_linear_regression_state_space_model}()},
\code{\link{sts_linear_regression}()},
\code{\link{sts_local_level}()},
\code{\link{sts_local_level_state_space_model}()},
\code{\link{sts_local_linear_trend}()},
\code{\link{sts_local_linear_trend_state_space_model}()},
\code{\link{sts_seasonal}()},
\code{\link{sts_seasonal_state_space_model}()},
\code{\link{sts_semi_local_linear_trend}()},
\code{\link{sts_semi_local_linear_trend_state_space_model}()},
\code{\link{sts_smooth_seasonal}()},
\code{\link{sts_smooth_seasonal_state_space_model}()},
\code{\link{sts_sparse_linear_regression}()},
\code{\link{sts_sum}()}
}
\concept{sts}
